"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(hub, ctx, name: str, shared_account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes permissions for the specified private image. After you delete permissions for an image, AWS accounts to which you previously granted these permissions can no longer use the image.

    Args:
        name(str): The name of the private image.
        shared_account_id(str): The 12-digit identifier of the AWS account for which to delete image permissions.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.image.permission.delete_multiple(
                ctx, name=value, shared_account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.image.permission.delete_multiple name=value, shared_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="delete_image_permissions",
        op_kwargs={"Name": name, "SharedAccountId": shared_account_id},
    )


async def describe_all(
    hub,
    ctx,
    name: str,
    max_results: int = None,
    shared_aws_account_ids: List = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own.

    Args:
        name(str): The name of the private image for which to describe permissions. The image must be one that you own. .
        max_results(int, optional): The maximum size of each page of results. Defaults to None.
        shared_aws_account_ids(List, optional): The 12-digit identifier of one or more AWS accounts with which the image is shared. Defaults to None.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.image.permission.describe_all(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.image.permission.describe_all name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="describe_image_permissions",
        op_kwargs={
            "Name": name,
            "MaxResults": max_results,
            "SharedAwsAccountIds": shared_aws_account_ids,
            "NextToken": next_token,
        },
    )


async def update_multiple(
    hub, ctx, name: str, shared_account_id: str, image_permissions: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Adds or updates permissions for the specified private image.

    Args:
        name(str): The name of the private image.
        shared_account_id(str): The 12-digit identifier of the AWS account for which you want add or update image permissions.
        image_permissions(Dict): The permissions for the image.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.image.permission.update_multiple(
                ctx, name=value, shared_account_id=value, image_permissions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.image.permission.update_multiple name=value, shared_account_id=value, image_permissions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="update_image_permissions",
        op_kwargs={
            "Name": name,
            "SharedAccountId": shared_account_id,
            "ImagePermissions": image_permissions,
        },
    )
