"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def copy(
    hub,
    ctx,
    source_image_name: str,
    destination_image_name: str,
    destination_region: str,
    destination_image_description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Copies the image within the same region or to a new region within the same AWS account. Note that any tags you added to the image will not be copied.

    Args:
        source_image_name(str): The name of the image to copy.
        destination_image_name(str): The name that the image will have when it is copied to the destination.
        destination_region(str): The destination region to which the image will be copied. This parameter is required, even if you are copying an image within the same region.
        destination_image_description(str, optional): The description that the image will have when it is copied to the destination. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.image.init.copy(
                ctx, source_image_name=value, destination_image_name=value, destination_region=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.image.init.copy source_image_name=value, destination_image_name=value, destination_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="copy_image",
        op_kwargs={
            "SourceImageName": source_image_name,
            "DestinationImageName": destination_image_name,
            "DestinationRegion": destination_region,
            "DestinationImageDescription": destination_image_description,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified image. You cannot delete an image when it is in use. After you delete an image, you cannot provision new capacity using the image.

    Args:
        name(str): The name of the image.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.image.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.image.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="delete_image",
        op_kwargs={"Name": name},
    )


async def describe_all(
    hub,
    ctx,
    names: List = None,
    arns: List = None,
    type_: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided. Otherwise, all images in the account are described.

    Args:
        names(List, optional): The names of the public or private images to describe. Defaults to None.
        arns(List, optional): The ARNs of the public, private, and shared images to describe. Defaults to None.
        type_(str, optional): The type of image (public, private, or shared) to describe. . Defaults to None.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.
        max_results(int, optional): The maximum size of each page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.image.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.image.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="describe_images",
        op_kwargs={
            "Names": names,
            "Arns": arns,
            "Type": type_,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
