"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str, validity: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a URL to start an image builder streaming session.

    Args:
        name(str): The name of the image builder.
        validity(int, optional): The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 3600 seconds. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.image.builder.streaming_url.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.image.builder.streaming_url.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="create_image_builder_streaming_url",
        op_kwargs={"Name": name, "Validity": validity},
    )
