"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    instance_type: str,
    image_name: str = None,
    image_arn: str = None,
    description: str = None,
    display_name: str = None,
    vpc_config: Dict = None,
    iam_role_arn: str = None,
    enable_default_internet_access: bool = None,
    domain_join_info: Dict = None,
    appstream_agent_version: str = None,
    tags: Dict = None,
    access_endpoints: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an image builder. An image builder is a virtual machine that is used to create an image. The initial state of the builder is PENDING. When it is ready, the state is RUNNING.

    Args:
        name(str): A unique name for the image builder.
        image_name(str, optional): The name of the image used to create the image builder. Defaults to None.
        image_arn(str, optional): The ARN of the public, private, or shared image to use. Defaults to None.
        instance_type(str): The instance type to use when launching the image builder. The following instance types are available:   stream.standard.small   stream.standard.medium   stream.standard.large   stream.compute.large   stream.compute.xlarge   stream.compute.2xlarge   stream.compute.4xlarge   stream.compute.8xlarge   stream.memory.large   stream.memory.xlarge   stream.memory.2xlarge   stream.memory.4xlarge   stream.memory.8xlarge   stream.memory.z1d.large   stream.memory.z1d.xlarge   stream.memory.z1d.2xlarge   stream.memory.z1d.3xlarge   stream.memory.z1d.6xlarge   stream.memory.z1d.12xlarge   stream.graphics-design.large   stream.graphics-design.xlarge   stream.graphics-design.2xlarge   stream.graphics-design.4xlarge   stream.graphics-desktop.2xlarge   stream.graphics.g4dn.xlarge   stream.graphics.g4dn.2xlarge   stream.graphics.g4dn.4xlarge   stream.graphics.g4dn.8xlarge   stream.graphics.g4dn.12xlarge   stream.graphics.g4dn.16xlarge   stream.graphics-pro.4xlarge   stream.graphics-pro.8xlarge   stream.graphics-pro.16xlarge  .
        description(str, optional): The description to display. Defaults to None.
        display_name(str, optional): The image builder name to display. Defaults to None.
        vpc_config(Dict, optional): The VPC configuration for the image builder. You can specify only one subnet. Defaults to None.
        iam_role_arn(str, optional): The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) AssumeRole API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the appstream_machine_role credential profile on the instance. For more information, see Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances in the Amazon AppStream 2.0 Administration Guide. Defaults to None.
        enable_default_internet_access(bool, optional): Enables or disables default internet access for the image builder. Defaults to None.
        domain_join_info(Dict, optional): The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. . Defaults to None.
        appstream_agent_version(str, optional): The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. . Defaults to None.
        tags(Dict, optional): The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=.  Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters:  _ . : / = + \ - @ If you do not specify a value, the value is set to an empty string. For more information about tags, see Tagging Your Resources in the Amazon AppStream 2.0 Administration Guide. Defaults to None.
        access_endpoints(List, optional): The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder only through the specified endpoints. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.image.builder.init.create(
                ctx, name=value, instance_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.image.builder.init.create name=value, instance_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="create_image_builder",
        op_kwargs={
            "Name": name,
            "ImageName": image_name,
            "ImageArn": image_arn,
            "InstanceType": instance_type,
            "Description": description,
            "DisplayName": display_name,
            "VpcConfig": vpc_config,
            "IamRoleArn": iam_role_arn,
            "EnableDefaultInternetAccess": enable_default_internet_access,
            "DomainJoinInfo": domain_join_info,
            "AppstreamAgentVersion": appstream_agent_version,
            "Tags": tags,
            "AccessEndpoints": access_endpoints,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified image builder and releases the capacity.

    Args:
        name(str): The name of the image builder.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.image.builder.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.image.builder.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="delete_image_builder",
        op_kwargs={"Name": name},
    )


async def describe_all(
    hub, ctx, names: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes one or more specified image builders, if the image builder names are provided. Otherwise, all image builders in the account are described.

    Args:
        names(List, optional): The names of the image builders to describe. Defaults to None.
        max_results(int, optional): The maximum size of each page of results. Defaults to None.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.image.builder.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.image.builder.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="describe_image_builders",
        op_kwargs={"Names": names, "MaxResults": max_results, "NextToken": next_token},
    )


async def start(hub, ctx, name: str, appstream_agent_version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Starts the specified image builder.

    Args:
        name(str): The name of the image builder.
        appstream_agent_version(str, optional): The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.image.builder.init.start(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.image.builder.init.start name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="start_image_builder",
        op_kwargs={"Name": name, "AppstreamAgentVersion": appstream_agent_version},
    )


async def stop(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops the specified image builder.

    Args:
        name(str): The name of the image builder.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.image.builder.init.stop(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.image.builder.init.stop name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="stop_image_builder",
        op_kwargs={"Name": name},
    )
