"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(hub, ctx, fleet_name: str, stack_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates the specified fleet with the specified stack.

    Args:
        fleet_name(str): The name of the fleet. .
        stack_name(str): The name of the stack.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.fleet.associate(
                ctx, fleet_name=value, stack_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.fleet.associate fleet_name=value, stack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="associate_fleet",
        op_kwargs={"FleetName": fleet_name, "StackName": stack_name},
    )


async def create(
    hub,
    ctx,
    name: str,
    instance_type: str,
    compute_capacity: Dict,
    image_name: str = None,
    image_arn: str = None,
    fleet_type: str = None,
    vpc_config: Dict = None,
    max_user_duration_in_seconds: int = None,
    disconnect_timeout_in_seconds: int = None,
    description: str = None,
    display_name: str = None,
    enable_default_internet_access: bool = None,
    domain_join_info: Dict = None,
    tags: Dict = None,
    idle_disconnect_timeout_in_seconds: int = None,
    iam_role_arn: str = None,
    stream_view: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a fleet. A fleet consists of streaming instances that run a specified image.

    Args:
        name(str): A unique name for the fleet.
        image_name(str, optional): The name of the image used to create the fleet. Defaults to None.
        image_arn(str, optional): The ARN of the public, private, or shared image to use. Defaults to None.
        instance_type(str): The instance type to use when launching fleet instances. The following instance types are available:   stream.standard.small   stream.standard.medium   stream.standard.large   stream.compute.large   stream.compute.xlarge   stream.compute.2xlarge   stream.compute.4xlarge   stream.compute.8xlarge   stream.memory.large   stream.memory.xlarge   stream.memory.2xlarge   stream.memory.4xlarge   stream.memory.8xlarge   stream.memory.z1d.large   stream.memory.z1d.xlarge   stream.memory.z1d.2xlarge   stream.memory.z1d.3xlarge   stream.memory.z1d.6xlarge   stream.memory.z1d.12xlarge   stream.graphics-design.large   stream.graphics-design.xlarge   stream.graphics-design.2xlarge   stream.graphics-design.4xlarge   stream.graphics-desktop.2xlarge   stream.graphics.g4dn.xlarge   stream.graphics.g4dn.2xlarge   stream.graphics.g4dn.4xlarge   stream.graphics.g4dn.8xlarge   stream.graphics.g4dn.12xlarge   stream.graphics.g4dn.16xlarge   stream.graphics-pro.4xlarge   stream.graphics-pro.8xlarge   stream.graphics-pro.16xlarge  .
        fleet_type(str, optional): The fleet type.  ALWAYS_ON  Provides users with instant-on access to their apps. You are charged for all running instances in your fleet, even if no users are streaming apps.  ON_DEMAND  Provide users with access to applications after they connect, which takes one to two minutes. You are charged for instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.  . Defaults to None.
        compute_capacity(Dict): The desired capacity for the fleet.
        vpc_config(Dict, optional): The VPC configuration for the fleet. Defaults to None.
        max_user_duration_in_seconds(int, optional): The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance. Specify a value between 600 and 360000. Defaults to None.
        disconnect_timeout_in_seconds(int, optional): The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.  Specify a value between 60 and 360000. Defaults to None.
        description(str, optional): The description to display. Defaults to None.
        display_name(str, optional): The fleet name to display. Defaults to None.
        enable_default_internet_access(bool, optional): Enables or disables default internet access for the fleet. Defaults to None.
        domain_join_info(Dict, optional): The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. . Defaults to None.
        tags(Dict, optional): The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=.  If you do not specify a value, the value is set to an empty string. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters:  _ . : / = + \ - @ For more information, see Tagging Your Resources in the Amazon AppStream 2.0 Administration Guide. Defaults to None.
        idle_disconnect_timeout_in_seconds(int, optional): The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the DisconnectTimeoutInSeconds time interval begins. Users are notified before they are disconnected due to inactivity. If they try to reconnect to the streaming session before the time interval specified in DisconnectTimeoutInSeconds elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in IdleDisconnectTimeoutInSeconds elapses, they are disconnected. To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.  If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity.  . Defaults to None.
        iam_role_arn(str, optional): The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) AssumeRole API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the appstream_machine_role credential profile on the instance. For more information, see Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances in the Amazon AppStream 2.0 Administration Guide. Defaults to None.
        stream_view(str, optional): The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When APP is specified, only the windows of applications opened by users display. When DESKTOP is specified, the standard desktop that is provided by the operating system displays. The default value is APP. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.fleet.create(
                ctx, name=value, instance_type=value, compute_capacity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.fleet.create name=value, instance_type=value, compute_capacity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="create_fleet",
        op_kwargs={
            "Name": name,
            "ImageName": image_name,
            "ImageArn": image_arn,
            "InstanceType": instance_type,
            "FleetType": fleet_type,
            "ComputeCapacity": compute_capacity,
            "VpcConfig": vpc_config,
            "MaxUserDurationInSeconds": max_user_duration_in_seconds,
            "DisconnectTimeoutInSeconds": disconnect_timeout_in_seconds,
            "Description": description,
            "DisplayName": display_name,
            "EnableDefaultInternetAccess": enable_default_internet_access,
            "DomainJoinInfo": domain_join_info,
            "Tags": tags,
            "IdleDisconnectTimeoutInSeconds": idle_disconnect_timeout_in_seconds,
            "IamRoleArn": iam_role_arn,
            "StreamView": stream_view,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified fleet.

    Args:
        name(str): The name of the fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.fleet.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.fleet.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="delete_fleet",
        op_kwargs={"Name": name},
    )


async def describe_all(hub, ctx, names: List = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes one or more specified fleets, if the fleet names are provided. Otherwise, all fleets in the account are described.

    Args:
        names(List, optional): The names of the fleets to describe. Defaults to None.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.fleet.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.fleet.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="describe_fleets",
        op_kwargs={"Names": names, "NextToken": next_token},
    )


async def disassociate(hub, ctx, fleet_name: str, stack_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified fleet from the specified stack.

    Args:
        fleet_name(str): The name of the fleet.
        stack_name(str): The name of the stack.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.fleet.disassociate(
                ctx, fleet_name=value, stack_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.fleet.disassociate fleet_name=value, stack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="disassociate_fleet",
        op_kwargs={"FleetName": fleet_name, "StackName": stack_name},
    )


async def start(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts the specified fleet.

    Args:
        name(str): The name of the fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.fleet.start(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.fleet.start name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="appstream", operation="start_fleet", op_kwargs={"Name": name}
    )


async def stop(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops the specified fleet.

    Args:
        name(str): The name of the fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.fleet.stop(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.fleet.stop name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="appstream", operation="stop_fleet", op_kwargs={"Name": name}
    )


async def update(
    hub,
    ctx,
    image_name: str = None,
    image_arn: str = None,
    name: str = None,
    instance_type: str = None,
    compute_capacity: Dict = None,
    vpc_config: Dict = None,
    max_user_duration_in_seconds: int = None,
    disconnect_timeout_in_seconds: int = None,
    delete_vpc_config: bool = None,
    description: str = None,
    display_name: str = None,
    enable_default_internet_access: bool = None,
    domain_join_info: Dict = None,
    idle_disconnect_timeout_in_seconds: int = None,
    attributes_to_delete: List = None,
    iam_role_arn: str = None,
    stream_view: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified fleet. If the fleet is in the STOPPED state, you can update any attribute except the fleet name. If the fleet is in the RUNNING state, you can update the DisplayName, ComputeCapacity, ImageARN, ImageName, IdleDisconnectTimeoutInSeconds, and DisconnectTimeoutInSeconds attributes. If the fleet is in the STARTING or STOPPING state, you can't update it.

    Args:
        image_name(str, optional): The name of the image used to create the fleet. Defaults to None.
        image_arn(str, optional): The ARN of the public, private, or shared image to use. Defaults to None.
        name(str, optional): A unique name for the fleet. Defaults to None.
        instance_type(str, optional): The instance type to use when launching fleet instances. The following instance types are available:   stream.standard.small   stream.standard.medium   stream.standard.large   stream.compute.large   stream.compute.xlarge   stream.compute.2xlarge   stream.compute.4xlarge   stream.compute.8xlarge   stream.memory.large   stream.memory.xlarge   stream.memory.2xlarge   stream.memory.4xlarge   stream.memory.8xlarge   stream.memory.z1d.large   stream.memory.z1d.xlarge   stream.memory.z1d.2xlarge   stream.memory.z1d.3xlarge   stream.memory.z1d.6xlarge   stream.memory.z1d.12xlarge   stream.graphics-design.large   stream.graphics-design.xlarge   stream.graphics-design.2xlarge   stream.graphics-design.4xlarge   stream.graphics-desktop.2xlarge   stream.graphics.g4dn.xlarge   stream.graphics.g4dn.2xlarge   stream.graphics.g4dn.4xlarge   stream.graphics.g4dn.8xlarge   stream.graphics.g4dn.12xlarge   stream.graphics.g4dn.16xlarge   stream.graphics-pro.4xlarge   stream.graphics-pro.8xlarge   stream.graphics-pro.16xlarge  . Defaults to None.
        compute_capacity(Dict, optional): The desired capacity for the fleet. Defaults to None.
        vpc_config(Dict, optional): The VPC configuration for the fleet. Defaults to None.
        max_user_duration_in_seconds(int, optional): The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance. Specify a value between 600 and 360000. Defaults to None.
        disconnect_timeout_in_seconds(int, optional): The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.  Specify a value between 60 and 360000. Defaults to None.
        delete_vpc_config(bool, optional): Deletes the VPC association for the specified fleet. Defaults to None.
        description(str, optional): The description to display. Defaults to None.
        display_name(str, optional): The fleet name to display. Defaults to None.
        enable_default_internet_access(bool, optional): Enables or disables default internet access for the fleet. Defaults to None.
        domain_join_info(Dict, optional): The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. . Defaults to None.
        idle_disconnect_timeout_in_seconds(int, optional): The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the DisconnectTimeoutInSeconds time interval begins. Users are notified before they are disconnected due to inactivity. If users try to reconnect to the streaming session before the time interval specified in DisconnectTimeoutInSeconds elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in IdleDisconnectTimeoutInSeconds elapses, they are disconnected.  To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.  If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity.  . Defaults to None.
        attributes_to_delete(List, optional): The fleet attributes to delete. Defaults to None.
        iam_role_arn(str, optional): The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) AssumeRole API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the appstream_machine_role credential profile on the instance. For more information, see Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances in the Amazon AppStream 2.0 Administration Guide. Defaults to None.
        stream_view(str, optional): The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When APP is specified, only the windows of applications opened by users display. When DESKTOP is specified, the standard desktop that is provided by the operating system displays. The default value is APP. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.fleet.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.fleet.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="update_fleet",
        op_kwargs={
            "ImageName": image_name,
            "ImageArn": image_arn,
            "Name": name,
            "InstanceType": instance_type,
            "ComputeCapacity": compute_capacity,
            "VpcConfig": vpc_config,
            "MaxUserDurationInSeconds": max_user_duration_in_seconds,
            "DisconnectTimeoutInSeconds": disconnect_timeout_in_seconds,
            "DeleteVpcConfig": delete_vpc_config,
            "Description": description,
            "DisplayName": display_name,
            "EnableDefaultInternetAccess": enable_default_internet_access,
            "DomainJoinInfo": domain_join_info,
            "IdleDisconnectTimeoutInSeconds": idle_disconnect_timeout_in_seconds,
            "AttributesToDelete": attributes_to_delete,
            "IamRoleArn": iam_role_arn,
            "StreamView": stream_view,
        },
    )
