"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, user_stack_associations: List) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified users from the specified stacks.

    Args:
        user_stack_associations(List): The list of UserStackAssociation objects.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.disassociate_user_stack.batch(
                ctx, user_stack_associations=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.disassociate_user_stack.batch user_stack_associations=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="batch_disassociate_user_stack",
        op_kwargs={"UserStackAssociations": user_stack_associations},
    )
