"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    directory_name: str,
    organizational_unit_distinguished_names: List,
    service_account_credentials: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.

    Args:
        directory_name(str): The fully qualified name of the directory (for example, corp.example.com).
        organizational_unit_distinguished_names(List): The distinguished names of the organizational units for computer accounts.
        service_account_credentials(Dict, optional): The credentials for the service account used by the fleet or image builder to connect to the directory. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.directory_config.create(
                ctx, directory_name=value, organizational_unit_distinguished_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.directory_config.create directory_name=value, organizational_unit_distinguished_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="create_directory_config",
        op_kwargs={
            "DirectoryName": directory_name,
            "OrganizationalUnitDistinguishedNames": organizational_unit_distinguished_names,
            "ServiceAccountCredentials": service_account_credentials,
        },
    )


async def delete(hub, ctx, directory_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified Directory Config object from AppStream 2.0. This object includes the information required to join streaming instances to an Active Directory domain.

    Args:
        directory_name(str): The name of the directory configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.directory_config.delete(ctx, directory_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.directory_config.delete directory_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="delete_directory_config",
        op_kwargs={"DirectoryName": directory_name},
    )


async def describe_all(
    hub,
    ctx,
    directory_names: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes one or more specified Directory Config objects for AppStream 2.0, if the names for these objects are provided. Otherwise, all Directory Config objects in the account are described. These objects include the configuration information required to join fleets and image builders to Microsoft Active Directory domains.  Although the response syntax in this topic includes the account password, this password is not returned in the actual response.

    Args:
        directory_names(List, optional): The directory names. Defaults to None.
        max_results(int, optional): The maximum size of each page of results. Defaults to None.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.directory_config.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.directory_config.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="describe_directory_configs",
        op_kwargs={
            "DirectoryNames": directory_names,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    directory_name: str,
    organizational_unit_distinguished_names: List = None,
    service_account_credentials: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.

    Args:
        directory_name(str): The name of the Directory Config object.
        organizational_unit_distinguished_names(List, optional): The distinguished names of the organizational units for computer accounts. Defaults to None.
        service_account_credentials(Dict, optional): The credentials for the service account used by the fleet or image builder to connect to the directory. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.directory_config.update(ctx, directory_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.directory_config.update directory_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="update_directory_config",
        op_kwargs={
            "DirectoryName": directory_name,
            "OrganizationalUnitDistinguishedNames": organizational_unit_distinguished_names,
            "ServiceAccountCredentials": service_account_credentials,
        },
    )
