"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, fleet_name: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the name of the stack with which the specified fleet is associated.

    Args:
        fleet_name(str): The name of the fleet.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.associated.stack.list_all(ctx, fleet_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.associated.stack.list_all fleet_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="list_associated_stacks",
        op_kwargs={"FleetName": fleet_name, "NextToken": next_token},
    )
