"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, stack_name: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the name of the fleet that is associated with the specified stack.

    Args:
        stack_name(str): The name of the stack.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.associated.fleet.list_all(ctx, stack_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.associated.fleet.list_all stack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="list_associated_fleets",
        op_kwargs={"StackName": stack_name, "NextToken": next_token},
    )
