"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    service_name: str,
    source_configuration: Dict,
    instance_configuration: Dict = None,
    tags: List = None,
    encryption_configuration: Dict = None,
    health_check_configuration: Dict = None,
    auto_scaling_configuration_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create an AWS App Runner service. After the service is created, the action also automatically starts a deployment. This is an asynchronous operation. On a successful call, you can use the returned OperationId and the ListOperations call to track the operation's progress.

    Args:
        service_name(str): A name for the new service. It must be unique across all the running App Runner services in your AWS account in the AWS Region.
        source_configuration(Dict): The source to deploy to the App Runner service. It can be a code or an image repository.
        instance_configuration(Dict, optional): The runtime configuration of instances (scaling units) of the App Runner service. Defaults to None.
        tags(List, optional): An optional list of metadata items that you can associate with your service resource. A tag is a key-value pair. Defaults to None.
        encryption_configuration(Dict, optional): An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an AWS managed CMK. Defaults to None.
        health_check_configuration(Dict, optional): The settings for the health check that AWS App Runner performs to monitor the health of your service. Defaults to None.
        auto_scaling_configuration_arn(str, optional): The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.service.create(
                ctx, service_name=value, source_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.service.create service_name=value, source_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="create_service",
        op_kwargs={
            "ServiceName": service_name,
            "SourceConfiguration": source_configuration,
            "InstanceConfiguration": instance_configuration,
            "Tags": tags,
            "EncryptionConfiguration": encryption_configuration,
            "HealthCheckConfiguration": health_check_configuration,
            "AutoScalingConfigurationArn": auto_scaling_configuration_arn,
        },
    )


async def delete(hub, ctx, service_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete an AWS App Runner service. This is an asynchronous operation. On a successful call, you can use the returned OperationId and the ListOperations call to track the operation's progress.

    Args:
        service_arn(str): The Amazon Resource Name (ARN) of the App Runner service that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.service.delete(ctx, service_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.service.delete service_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="delete_service",
        op_kwargs={"ServiceArn": service_arn},
    )


async def describe(hub, ctx, service_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Return a full description of an AWS App Runner service.

    Args:
        service_arn(str): The Amazon Resource Name (ARN) of the App Runner service that you want a description for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.service.describe(ctx, service_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.service.describe service_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="describe_service",
        op_kwargs={"ServiceArn": service_arn},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of running AWS App Runner services in your AWS account.

    Args:
        next_token(str, optional): A token from a previous result page. Used for a paginated request. The request retrieves the next result page. All other parameter values must be identical to the ones specified in the initial request. If you don't specify NextToken, the request retrieves the first result page. Defaults to None.
        max_results(int, optional): The maximum number of results to include in each response (result page). It's used for a paginated request. If you don't specify MaxResults, the request retrieves all available results in a single response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.service.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.service.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="list_services",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def pause(hub, ctx, service_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Pause an active AWS App Runner service. App Runner reduces compute capacity for the service to zero and loses state (for example, ephemeral storage is removed). This is an asynchronous operation. On a successful call, you can use the returned OperationId and the ListOperations call to track the operation's progress.

    Args:
        service_arn(str): The Amazon Resource Name (ARN) of the App Runner service that you want to pause.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.service.pause(ctx, service_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.service.pause service_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="pause_service",
        op_kwargs={"ServiceArn": service_arn},
    )


async def resume(hub, ctx, service_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Resume an active AWS App Runner service. App Runner provisions compute capacity for the service. This is an asynchronous operation. On a successful call, you can use the returned OperationId and the ListOperations call to track the operation's progress.

    Args:
        service_arn(str): The Amazon Resource Name (ARN) of the App Runner service that you want to resume.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.service.resume(ctx, service_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.service.resume service_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="resume_service",
        op_kwargs={"ServiceArn": service_arn},
    )


async def update(
    hub,
    ctx,
    service_arn: str,
    source_configuration: Dict = None,
    instance_configuration: Dict = None,
    auto_scaling_configuration_arn: str = None,
    health_check_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update an AWS App Runner service. You can update the source configuration and instance configuration of the service. You can also update the ARN of the auto scaling configuration resource that's associated with the service. However, you can't change the name or the encryption configuration of the service. These can be set only when you create the service. To update the tags applied to your service, use the separate actions TagResource and UntagResource. This is an asynchronous operation. On a successful call, you can use the returned OperationId and the ListOperations call to track the operation's progress.

    Args:
        service_arn(str): The Amazon Resource Name (ARN) of the App Runner service that you want to update.
        source_configuration(Dict, optional): The source configuration to apply to the App Runner service. You can change the configuration of the code or image repository that the service uses. However, you can't switch from code to image or the other way around. This means that you must provide the same structure member of SourceConfiguration that you originally included when you created the service. Specifically, you can include either CodeRepository or ImageRepository. To update the source configuration, set the values to members of the structure that you include. Defaults to None.
        instance_configuration(Dict, optional): The runtime configuration to apply to instances (scaling units) of the App Runner service. Defaults to None.
        auto_scaling_configuration_arn(str, optional): The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service. Defaults to None.
        health_check_configuration(Dict, optional): The settings for the health check that AWS App Runner performs to monitor the health of your service. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.service.update(ctx, service_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.service.update service_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="update_service",
        op_kwargs={
            "ServiceArn": service_arn,
            "SourceConfiguration": source_configuration,
            "InstanceConfiguration": instance_configuration,
            "AutoScalingConfigurationArn": auto_scaling_configuration_arn,
            "HealthCheckConfiguration": health_check_configuration,
        },
    )
