"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, service_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Return a list of operations that occurred on an AWS App Runner service. The resulting list of OperationSummary objects is sorted in reverse chronological order. The first object on the list represents the last started operation.

    Args:
        service_arn(str): The Amazon Resource Name (ARN) of the App Runner service that you want a list of operations for.
        next_token(str, optional): A token from a previous result page. It's used for a paginated request. The request retrieves the next result page. All other parameter values must be identical to the ones specified in the initial request. If you don't specify NextToken, the request retrieves the first result page. Defaults to None.
        max_results(int, optional): The maximum number of results to include in each response (result page). It's used for a paginated request. If you don't specify MaxResults, the request retrieves all available results in a single response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.operation.list_all(ctx, service_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.operation.list_all service_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="list_operations",
        op_kwargs={
            "ServiceArn": service_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
