"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, service_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Initiate a manual deployment of the latest commit in a source code repository or the latest image in a source image repository to an AWS App Runner service. For a source code repository, App Runner retrieves the commit and builds a Docker image. For a source image repository, App Runner retrieves the latest Docker image. In both cases, App Runner then deploys the new image to your service and starts a new container instance. This is an asynchronous operation. On a successful call, you can use the returned OperationId and the ListOperations call to track the operation's progress.

    Args:
        service_arn(str): The Amazon Resource Name (ARN) of the App Runner service that you want to manually deploy to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.deployment.start(ctx, service_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.deployment.start service_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="start_deployment",
        op_kwargs={"ServiceArn": service_arn},
    )
