"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub, ctx, service_arn: str, domain_name: str, enable_www_subdomain: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Associate your own domain name with the AWS App Runner subdomain URL of your App Runner service. After you call AssociateCustomDomain and receive a successful response, use the information in the CustomDomain record that's returned to add CNAME records to your Domain Name System (DNS). For each mapped domain name, add a mapping to the target App Runner subdomain and one or more certificate validation records. App Runner then performs DNS validation to verify that you own or control the domain name that you associated. App Runner tracks domain validity in a certificate stored in AWS Certificate Manager (ACM).

    Args:
        service_arn(str): The Amazon Resource Name (ARN) of the App Runner service that you want to associate a custom domain name with.
        domain_name(str): A custom domain endpoint to associate. Specify a root domain (for example, example.com), a subdomain (for example, login.example.com or admin.login.example.com), or a wildcard (for example, *.example.com).
        enable_www_subdomain(bool, optional): Set to true to associate the subdomain www.DomainName  with the App Runner service in addition to the base domain. Default: true . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.custom_domain.associate(
                ctx, service_arn=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.custom_domain.associate service_arn=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="associate_custom_domain",
        op_kwargs={
            "ServiceArn": service_arn,
            "DomainName": domain_name,
            "EnableWWWSubdomain": enable_www_subdomain,
        },
    )


async def describe_all(
    hub, ctx, service_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Return a description of custom domain names that are associated with an AWS App Runner service.

    Args:
        service_arn(str): The Amazon Resource Name (ARN) of the App Runner service that you want associated custom domain names to be described for.
        next_token(str, optional): A token from a previous result page. It's used for a paginated request. The request retrieves the next result page. All other parameter values must be identical to the ones that are specified in the initial request. If you don't specify NextToken, the request retrieves the first result page. Defaults to None.
        max_results(int, optional): The maximum number of results that each response (result page) can include. It's used for a paginated request. If you don't specify MaxResults, the request retrieves all available results in a single response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.custom_domain.describe_all(ctx, service_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.custom_domain.describe_all service_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="describe_custom_domains",
        op_kwargs={
            "ServiceArn": service_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def disassociate(hub, ctx, service_arn: str, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociate a custom domain name from an AWS App Runner service. Certificates tracking domain validity are associated with a custom domain and are stored in AWS Certificate Manager (ACM). These certificates aren't deleted as part of this action. App Runner delays certificate deletion for 30 days after a domain is disassociated from your service.

    Args:
        service_arn(str): The Amazon Resource Name (ARN) of the App Runner service that you want to disassociate a custom domain name from.
        domain_name(str): The domain name that you want to disassociate from the App Runner service.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.custom_domain.disassociate(
                ctx, service_arn=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.custom_domain.disassociate service_arn=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="disassociate_custom_domain",
        op_kwargs={"ServiceArn": service_arn, "DomainName": domain_name},
    )
