"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, connection_name: str, provider_type: str, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Create an AWS App Runner connection resource. App Runner requires a connection resource when you create App Runner services that access private repositories from certain third-party providers. You can share a connection across multiple services. A connection resource is needed to access GitHub repositories. GitHub requires a user interface approval process through the App Runner console before you can use the connection.

    Args:
        connection_name(str): A name for the new connection. It must be unique across all App Runner connections for the AWS account in the AWS Region.
        provider_type(str): The source repository provider.
        tags(List, optional): A list of metadata items that you can associate with your connection resource. A tag is a key-value pair. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.connection.create(
                ctx, connection_name=value, provider_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.connection.create connection_name=value, provider_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="create_connection",
        op_kwargs={
            "ConnectionName": connection_name,
            "ProviderType": provider_type,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, connection_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete an AWS App Runner connection. You must first ensure that there are no running App Runner services that use this connection. If there are any, the DeleteConnection action fails.

    Args:
        connection_arn(str): The Amazon Resource Name (ARN) of the App Runner connection that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.connection.delete(ctx, connection_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.connection.delete connection_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="delete_connection",
        op_kwargs={"ConnectionArn": connection_arn},
    )


async def list_all(
    hub,
    ctx,
    connection_name: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of AWS App Runner connections that are associated with your AWS account.

    Args:
        connection_name(str, optional): If specified, only this connection is returned. If not specified, the result isn't filtered by name. Defaults to None.
        max_results(int, optional): The maximum number of results to include in each response (result page). Used for a paginated request. If you don't specify MaxResults, the request retrieves all available results in a single response. Defaults to None.
        next_token(str, optional): A token from a previous result page. Used for a paginated request. The request retrieves the next result page. All other parameter values must be identical to the ones specified in the initial request. If you don't specify NextToken, the request retrieves the first result page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.connection.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.connection.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="list_connections",
        op_kwargs={
            "ConnectionName": connection_name,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
