"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    auto_scaling_configuration_name: str,
    max_concurrency: int = None,
    min_size: int = None,
    max_size: int = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create an AWS App Runner automatic scaling configuration resource. App Runner requires this resource when you create App Runner services that require non-default auto scaling settings. You can share an auto scaling configuration across multiple services. Create multiple revisions of a configuration by using the same AutoScalingConfigurationName and different AutoScalingConfigurationRevision values. When you create a service, you can set it to use the latest active revision of an auto scaling configuration or a specific revision. Configure a higher MinSize to increase the spread of your App Runner service over more Availability Zones in the AWS Region. The tradeoff is a higher minimal cost. Configure a lower MaxSize to control your cost. The tradeoff is lower responsiveness during peak demand.

    Args:
        auto_scaling_configuration_name(str): A name for the auto scaling configuration. When you use it for the first time in an AWS Region, App Runner creates revision number 1 of this name. When you use the same name in subsequent calls, App Runner creates incremental revisions of the configuration.
        max_concurrency(int, optional): The maximum number of concurrent requests that you want an instance to process. If the number of concurrent requests exceeds this limit, App Runner scales up your service. Default: 100 . Defaults to None.
        min_size(int, optional): The minimum number of instances that App Runner provisions for your service. The service always has at least MinSize provisioned instances. Some of them actively serve traffic. The rest of them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset. App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code. Default: 1 . Defaults to None.
        max_size(int, optional): The maximum number of instances that your service scales up to. At most MaxSize instances actively serve traffic for your service. Default: 25 . Defaults to None.
        tags(List, optional): A list of metadata items that you can associate with your auto scaling configuration resource. A tag is a key-value pair. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.auto_scaling_configuration.create(
                ctx, auto_scaling_configuration_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.auto_scaling_configuration.create auto_scaling_configuration_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="create_auto_scaling_configuration",
        op_kwargs={
            "AutoScalingConfigurationName": auto_scaling_configuration_name,
            "MaxConcurrency": max_concurrency,
            "MinSize": min_size,
            "MaxSize": max_size,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, auto_scaling_configuration_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete an AWS App Runner automatic scaling configuration resource. You can delete a specific revision or the latest active revision. You can't delete a configuration that's used by one or more App Runner services.

    Args:
        auto_scaling_configuration_arn(str): The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want to delete. The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either .../name  or .../name/revision . If a revision isn't specified, the latest active revision is deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.auto_scaling_configuration.delete(
                ctx, auto_scaling_configuration_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.auto_scaling_configuration.delete auto_scaling_configuration_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="delete_auto_scaling_configuration",
        op_kwargs={"AutoScalingConfigurationArn": auto_scaling_configuration_arn},
    )


async def describe(hub, ctx, auto_scaling_configuration_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Return a full description of an AWS App Runner automatic scaling configuration resource.

    Args:
        auto_scaling_configuration_arn(str): The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want a description for. The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either .../name  or .../name/revision . If a revision isn't specified, the latest active revision is described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.auto_scaling_configuration.describe(
                ctx, auto_scaling_configuration_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.auto_scaling_configuration.describe auto_scaling_configuration_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="describe_auto_scaling_configuration",
        op_kwargs={"AutoScalingConfigurationArn": auto_scaling_configuration_arn},
    )


async def list_all(
    hub,
    ctx,
    auto_scaling_configuration_name: str = None,
    latest_only: bool = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of AWS App Runner automatic scaling configurations in your AWS account. You can query the revisions for a specific configuration name or the revisions for all configurations in your account. You can optionally query only the latest revision of each requested name.

    Args:
        auto_scaling_configuration_name(str, optional): The name of the App Runner auto scaling configuration that you want to list. If specified, App Runner lists revisions that share this name. If not specified, App Runner returns revisions of all configurations. Defaults to None.
        latest_only(bool, optional): Set to true to list only the latest revision for each requested configuration name. Keep as false to list all revisions for each requested configuration name. Default: false . Defaults to None.
        max_results(int, optional): The maximum number of results to include in each response (result page). It's used for a paginated request. If you don't specify MaxResults, the request retrieves all available results in a single response. Defaults to None.
        next_token(str, optional): A token from a previous result page. It's used for a paginated request. The request retrieves the next result page. All other parameter values must be identical to the ones that are specified in the initial request. If you don't specify NextToken, the request retrieves the first result page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apprunner.auto_scaling_configuration.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apprunner.auto_scaling_configuration.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apprunner",
        operation="list_auto_scaling_configurations",
        op_kwargs={
            "AutoScalingConfigurationName": auto_scaling_configuration_name,
            "LatestOnly": latest_only,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
