"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    mesh_name: str,
    spec: Dict,
    virtual_service_name: str,
    client_token: str = None,
    mesh_owner: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a virtual service within a service mesh. A virtual service is an abstraction of a real service that is provided by a virtual node directly or indirectly by means of a virtual router. Dependent services call your virtual service by its virtualServiceName, and those requests are routed to the virtual node or virtual router that is specified as the provider for the virtual service. For more information about virtual services, see Virtual services.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed. Defaults to None.
        mesh_name(str): The name of the service mesh to create the virtual service in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        spec(Dict): The virtual service specification to apply.
        tags(List, optional): Optional metadata that you can apply to the virtual service to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters. Defaults to None.
        virtual_service_name(str): The name to use for the virtual service.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.service.create(
                ctx, mesh_name=value, spec=value, virtual_service_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.service.create mesh_name=value, spec=value, virtual_service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="create_virtual_service",
        op_kwargs={
            "clientToken": client_token,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "spec": spec,
            "tags": tags,
            "virtualServiceName": virtual_service_name,
        },
    )


async def delete(
    hub, ctx, mesh_name: str, virtual_service_name: str, mesh_owner: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing virtual service.

    Args:
        mesh_name(str): The name of the service mesh to delete the virtual service in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        virtual_service_name(str): The name of the virtual service to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.service.delete(
                ctx, mesh_name=value, virtual_service_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.service.delete mesh_name=value, virtual_service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="delete_virtual_service",
        op_kwargs={
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "virtualServiceName": virtual_service_name,
        },
    )


async def describe(
    hub, ctx, mesh_name: str, virtual_service_name: str, mesh_owner: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes an existing virtual service.

    Args:
        mesh_name(str): The name of the service mesh that the virtual service resides in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        virtual_service_name(str): The name of the virtual service to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.service.describe(
                ctx, mesh_name=value, virtual_service_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.service.describe mesh_name=value, virtual_service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="describe_virtual_service",
        op_kwargs={
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "virtualServiceName": virtual_service_name,
        },
    )


async def list_all(
    hub,
    ctx,
    mesh_name: str,
    limit: int = None,
    mesh_owner: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of existing virtual services in a service mesh.

    Args:
        limit(int, optional): The maximum number of results returned by ListVirtualServices in paginated output. When you use this parameter, ListVirtualServices returns only limit results in a single page along with a nextToken response element. You can see the remaining results of the initial request by sending another ListVirtualServices request with the returned nextToken value. This value can be between 1 and 100. If you don't use this parameter, ListVirtualServices returns up to 100 results and a nextToken value if applicable. Defaults to None.
        mesh_name(str): The name of the service mesh to list virtual services in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListVirtualServices request where limit was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.service.list_all(ctx, mesh_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.service.list_all mesh_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="list_virtual_services",
        op_kwargs={
            "limit": limit,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    mesh_name: str,
    spec: Dict,
    virtual_service_name: str,
    client_token: str = None,
    mesh_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing virtual service in a specified service mesh.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed. Defaults to None.
        mesh_name(str): The name of the service mesh that the virtual service resides in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        spec(Dict): The new virtual service specification to apply. This overwrites the existing data.
        virtual_service_name(str): The name of the virtual service to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.service.update(
                ctx, mesh_name=value, spec=value, virtual_service_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.service.update mesh_name=value, spec=value, virtual_service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="update_virtual_service",
        op_kwargs={
            "clientToken": client_token,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "spec": spec,
            "virtualServiceName": virtual_service_name,
        },
    )
