"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    mesh_name: str,
    spec: Dict,
    virtual_router_name: str,
    client_token: str = None,
    mesh_owner: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a virtual router within a service mesh. Specify a listener for any inbound traffic that your virtual router receives. Create a virtual router for each protocol and port that you need to route. Virtual routers handle traffic for one or more virtual services within your mesh. After you create your virtual router, create and associate routes for your virtual router that direct incoming requests to different virtual nodes. For more information about virtual routers, see Virtual routers.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed. Defaults to None.
        mesh_name(str): The name of the service mesh to create the virtual router in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        spec(Dict): The virtual router specification to apply.
        tags(List, optional): Optional metadata that you can apply to the virtual router to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters. Defaults to None.
        virtual_router_name(str): The name to use for the virtual router.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.router.create(
                ctx, mesh_name=value, spec=value, virtual_router_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.router.create mesh_name=value, spec=value, virtual_router_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="create_virtual_router",
        op_kwargs={
            "clientToken": client_token,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "spec": spec,
            "tags": tags,
            "virtualRouterName": virtual_router_name,
        },
    )


async def delete(
    hub, ctx, mesh_name: str, virtual_router_name: str, mesh_owner: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing virtual router. You must delete any routes associated with the virtual router before you can delete the router itself.

    Args:
        mesh_name(str): The name of the service mesh to delete the virtual router in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        virtual_router_name(str): The name of the virtual router to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.router.delete(
                ctx, mesh_name=value, virtual_router_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.router.delete mesh_name=value, virtual_router_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="delete_virtual_router",
        op_kwargs={
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "virtualRouterName": virtual_router_name,
        },
    )


async def describe(
    hub, ctx, mesh_name: str, virtual_router_name: str, mesh_owner: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes an existing virtual router.

    Args:
        mesh_name(str): The name of the service mesh that the virtual router resides in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        virtual_router_name(str): The name of the virtual router to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.router.describe(
                ctx, mesh_name=value, virtual_router_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.router.describe mesh_name=value, virtual_router_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="describe_virtual_router",
        op_kwargs={
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "virtualRouterName": virtual_router_name,
        },
    )


async def list_all(
    hub,
    ctx,
    mesh_name: str,
    limit: int = None,
    mesh_owner: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of existing virtual routers in a service mesh.

    Args:
        limit(int, optional): The maximum number of results returned by ListVirtualRouters in paginated output. When you use this parameter, ListVirtualRouters returns only limit results in a single page along with a nextToken response element. You can see the remaining results of the initial request by sending another ListVirtualRouters request with the returned nextToken value. This value can be between 1 and 100. If you don't use this parameter, ListVirtualRouters returns up to 100 results and a nextToken value if applicable. Defaults to None.
        mesh_name(str): The name of the service mesh to list virtual routers in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListVirtualRouters request where limit was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.router.list_all(ctx, mesh_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.router.list_all mesh_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="list_virtual_routers",
        op_kwargs={
            "limit": limit,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    mesh_name: str,
    spec: Dict,
    virtual_router_name: str,
    client_token: str = None,
    mesh_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing virtual router in a specified service mesh.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed. Defaults to None.
        mesh_name(str): The name of the service mesh that the virtual router resides in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        spec(Dict): The new virtual router specification to apply. This overwrites the existing data.
        virtual_router_name(str): The name of the virtual router to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.router.update(
                ctx, mesh_name=value, spec=value, virtual_router_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.router.update mesh_name=value, spec=value, virtual_router_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="update_virtual_router",
        op_kwargs={
            "clientToken": client_token,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "spec": spec,
            "virtualRouterName": virtual_router_name,
        },
    )
