"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    mesh_name: str,
    spec: Dict,
    virtual_gateway_name: str,
    client_token: str = None,
    mesh_owner: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a virtual gateway. A virtual gateway allows resources outside your mesh to communicate to resources that are inside your mesh. The virtual gateway represents an Envoy proxy running in an Amazon ECS task, in a Kubernetes service, or on an Amazon EC2 instance. Unlike a virtual node, which represents an Envoy running with an application, a virtual gateway represents Envoy deployed by itself. For more information about virtual gateways, see Virtual gateways.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed. Defaults to None.
        mesh_name(str): The name of the service mesh to create the virtual gateway in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        spec(Dict): The virtual gateway specification to apply.
        tags(List, optional): Optional metadata that you can apply to the virtual gateway to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters. Defaults to None.
        virtual_gateway_name(str): The name to use for the virtual gateway.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.gateway.create(
                ctx, mesh_name=value, spec=value, virtual_gateway_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.gateway.create mesh_name=value, spec=value, virtual_gateway_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="create_virtual_gateway",
        op_kwargs={
            "clientToken": client_token,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "spec": spec,
            "tags": tags,
            "virtualGatewayName": virtual_gateway_name,
        },
    )


async def delete(
    hub, ctx, mesh_name: str, virtual_gateway_name: str, mesh_owner: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing virtual gateway. You cannot delete a virtual gateway if any gateway routes are associated to it.

    Args:
        mesh_name(str): The name of the service mesh to delete the virtual gateway from.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        virtual_gateway_name(str): The name of the virtual gateway to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.gateway.delete(
                ctx, mesh_name=value, virtual_gateway_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.gateway.delete mesh_name=value, virtual_gateway_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="delete_virtual_gateway",
        op_kwargs={
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "virtualGatewayName": virtual_gateway_name,
        },
    )


async def describe(
    hub, ctx, mesh_name: str, virtual_gateway_name: str, mesh_owner: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes an existing virtual gateway.

    Args:
        mesh_name(str): The name of the service mesh that the gateway route resides in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        virtual_gateway_name(str): The name of the virtual gateway to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.gateway.describe(
                ctx, mesh_name=value, virtual_gateway_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.gateway.describe mesh_name=value, virtual_gateway_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="describe_virtual_gateway",
        op_kwargs={
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "virtualGatewayName": virtual_gateway_name,
        },
    )


async def list_all(
    hub,
    ctx,
    mesh_name: str,
    limit: int = None,
    mesh_owner: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of existing virtual gateways in a service mesh.

    Args:
        limit(int, optional): The maximum number of results returned by ListVirtualGateways in paginated output. When you use this parameter, ListVirtualGateways returns only limit results in a single page along with a nextToken response element. You can see the remaining results of the initial request by sending another ListVirtualGateways request with the returned nextToken value. This value can be between 1 and 100. If you don't use this parameter, ListVirtualGateways returns up to 100 results and a nextToken value if applicable. Defaults to None.
        mesh_name(str): The name of the service mesh to list virtual gateways in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListVirtualGateways request where limit was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.gateway.list_all(ctx, mesh_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.gateway.list_all mesh_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="list_virtual_gateways",
        op_kwargs={
            "limit": limit,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    mesh_name: str,
    spec: Dict,
    virtual_gateway_name: str,
    client_token: str = None,
    mesh_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing virtual gateway in a specified service mesh.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed. Defaults to None.
        mesh_name(str): The name of the service mesh that the virtual gateway resides in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        spec(Dict): The new virtual gateway specification to apply. This overwrites the existing data.
        virtual_gateway_name(str): The name of the virtual gateway to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.virtual.gateway.update(
                ctx, mesh_name=value, spec=value, virtual_gateway_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.virtual.gateway.update mesh_name=value, spec=value, virtual_gateway_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="update_virtual_gateway",
        op_kwargs={
            "clientToken": client_token,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "spec": spec,
            "virtualGatewayName": virtual_gateway_name,
        },
    )
