"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, resource_arn: str, limit: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List the tags for an App Mesh resource.

    Args:
        limit(int, optional): The maximum number of tag results returned by ListTagsForResource in paginated output. When this parameter is used, ListTagsForResource returns only limit results in a single page along with a nextToken response element. You can see the remaining results of the initial request by sending another ListTagsForResource request with the returned nextToken value. This value can be between 1 and 100. If you don't use this parameter, ListTagsForResource returns up to 100 results and a nextToken value if applicable. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListTagsForResource request where limit was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. Defaults to None.
        resource_arn(str): The Amazon Resource Name (ARN) that identifies the resource to list the tags for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.tags_for_resource.list(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.tags_for_resource.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="list_tags_for_resource",
        op_kwargs={
            "limit": limit,
            "nextToken": next_token,
            "resourceArn": resource_arn,
        },
    )
