"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    mesh_name: str,
    route_name: str,
    spec: Dict,
    virtual_router_name: str,
    client_token: str = None,
    mesh_owner: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a route that is associated with a virtual router.  You can route several different protocols and define a retry policy for a route. Traffic can be routed to one or more virtual nodes. For more information about routes, see Routes.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed. Defaults to None.
        mesh_name(str): The name of the service mesh to create the route in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        route_name(str): The name to use for the route.
        spec(Dict): The route specification to apply.
        tags(List, optional): Optional metadata that you can apply to the route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters. Defaults to None.
        virtual_router_name(str): The name of the virtual router in which to create the route. If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.route.create(
                ctx, mesh_name=value, route_name=value, spec=value, virtual_router_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.route.create mesh_name=value, route_name=value, spec=value, virtual_router_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="create_route",
        op_kwargs={
            "clientToken": client_token,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "routeName": route_name,
            "spec": spec,
            "tags": tags,
            "virtualRouterName": virtual_router_name,
        },
    )


async def delete(
    hub,
    ctx,
    mesh_name: str,
    route_name: str,
    virtual_router_name: str,
    mesh_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing route.

    Args:
        mesh_name(str): The name of the service mesh to delete the route in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        route_name(str): The name of the route to delete.
        virtual_router_name(str): The name of the virtual router to delete the route in.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.route.delete(
                ctx, mesh_name=value, route_name=value, virtual_router_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.route.delete mesh_name=value, route_name=value, virtual_router_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="delete_route",
        op_kwargs={
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "routeName": route_name,
            "virtualRouterName": virtual_router_name,
        },
    )


async def describe(
    hub,
    ctx,
    mesh_name: str,
    route_name: str,
    virtual_router_name: str,
    mesh_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes an existing route.

    Args:
        mesh_name(str): The name of the service mesh that the route resides in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        route_name(str): The name of the route to describe.
        virtual_router_name(str): The name of the virtual router that the route is associated with.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.route.describe(
                ctx, mesh_name=value, route_name=value, virtual_router_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.route.describe mesh_name=value, route_name=value, virtual_router_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="describe_route",
        op_kwargs={
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "routeName": route_name,
            "virtualRouterName": virtual_router_name,
        },
    )


async def list_all(
    hub,
    ctx,
    mesh_name: str,
    virtual_router_name: str,
    limit: int = None,
    mesh_owner: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of existing routes in a service mesh.

    Args:
        limit(int, optional): The maximum number of results returned by ListRoutes in paginated output. When you use this parameter, ListRoutes returns only limit results in a single page along with a nextToken response element. You can see the remaining results of the initial request by sending another ListRoutes request with the returned nextToken value. This value can be between 1 and 100. If you don't use this parameter, ListRoutes returns up to 100 results and a nextToken value if applicable. Defaults to None.
        mesh_name(str): The name of the service mesh to list routes in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListRoutes request where limit was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. Defaults to None.
        virtual_router_name(str): The name of the virtual router to list routes in.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.route.list_all(
                ctx, mesh_name=value, virtual_router_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.route.list_all mesh_name=value, virtual_router_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="list_routes",
        op_kwargs={
            "limit": limit,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "nextToken": next_token,
            "virtualRouterName": virtual_router_name,
        },
    )


async def update(
    hub,
    ctx,
    mesh_name: str,
    route_name: str,
    spec: Dict,
    virtual_router_name: str,
    client_token: str = None,
    mesh_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing route for a specified service mesh and virtual router.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed. Defaults to None.
        mesh_name(str): The name of the service mesh that the route resides in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        route_name(str): The name of the route to update.
        spec(Dict): The new route specification to apply. This overwrites the existing data.
        virtual_router_name(str): The name of the virtual router that the route is associated with.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.route.update(
                ctx, mesh_name=value, route_name=value, spec=value, virtual_router_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.route.update mesh_name=value, route_name=value, spec=value, virtual_router_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="update_route",
        op_kwargs={
            "clientToken": client_token,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "routeName": route_name,
            "spec": spec,
            "virtualRouterName": virtual_router_name,
        },
    )
