"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    gateway_route_name: str,
    mesh_name: str,
    spec: Dict,
    virtual_gateway_name: str,
    client_token: str = None,
    mesh_owner: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a gateway route. A gateway route is attached to a virtual gateway and routes traffic to an existing virtual service. If a route matches a request, it can distribute traffic to a target virtual service. For more information about gateway routes, see Gateway routes.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed. Defaults to None.
        gateway_route_name(str): The name to use for the gateway route.
        mesh_name(str): The name of the service mesh to create the gateway route in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        spec(Dict): The gateway route specification to apply.
        tags(List, optional): Optional metadata that you can apply to the gateway route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters. Defaults to None.
        virtual_gateway_name(str): The name of the virtual gateway to associate the gateway route with. If the virtual gateway is in a shared mesh, then you must be the owner of the virtual gateway resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.gateway_route.create(
                ctx,
                gateway_route_name=value,
                mesh_name=value,
                spec=value,
                virtual_gateway_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.gateway_route.create gateway_route_name=value, mesh_name=value, spec=value, virtual_gateway_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="create_gateway_route",
        op_kwargs={
            "clientToken": client_token,
            "gatewayRouteName": gateway_route_name,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "spec": spec,
            "tags": tags,
            "virtualGatewayName": virtual_gateway_name,
        },
    )


async def delete(
    hub,
    ctx,
    gateway_route_name: str,
    mesh_name: str,
    virtual_gateway_name: str,
    mesh_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing gateway route.

    Args:
        gateway_route_name(str): The name of the gateway route to delete.
        mesh_name(str): The name of the service mesh to delete the gateway route from.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        virtual_gateway_name(str): The name of the virtual gateway to delete the route from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.gateway_route.delete(
                ctx, gateway_route_name=value, mesh_name=value, virtual_gateway_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.gateway_route.delete gateway_route_name=value, mesh_name=value, virtual_gateway_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="delete_gateway_route",
        op_kwargs={
            "gatewayRouteName": gateway_route_name,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "virtualGatewayName": virtual_gateway_name,
        },
    )


async def describe(
    hub,
    ctx,
    gateway_route_name: str,
    mesh_name: str,
    virtual_gateway_name: str,
    mesh_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes an existing gateway route.

    Args:
        gateway_route_name(str): The name of the gateway route to describe.
        mesh_name(str): The name of the service mesh that the gateway route resides in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        virtual_gateway_name(str): The name of the virtual gateway that the gateway route is associated with.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.gateway_route.describe(
                ctx, gateway_route_name=value, mesh_name=value, virtual_gateway_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.gateway_route.describe gateway_route_name=value, mesh_name=value, virtual_gateway_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="describe_gateway_route",
        op_kwargs={
            "gatewayRouteName": gateway_route_name,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "virtualGatewayName": virtual_gateway_name,
        },
    )


async def list_all(
    hub,
    ctx,
    mesh_name: str,
    virtual_gateway_name: str,
    limit: int = None,
    mesh_owner: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of existing gateway routes that are associated to a virtual gateway.

    Args:
        limit(int, optional): The maximum number of results returned by ListGatewayRoutes in paginated output. When you use this parameter, ListGatewayRoutes returns only limit results in a single page along with a nextToken response element. You can see the remaining results of the initial request by sending another ListGatewayRoutes request with the returned nextToken value. This value can be between 1 and 100. If you don't use this parameter, ListGatewayRoutes returns up to 100 results and a nextToken value if applicable. Defaults to None.
        mesh_name(str): The name of the service mesh to list gateway routes in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListGatewayRoutes request where limit was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. Defaults to None.
        virtual_gateway_name(str): The name of the virtual gateway to list gateway routes in.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.gateway_route.list_all(
                ctx, mesh_name=value, virtual_gateway_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.gateway_route.list_all mesh_name=value, virtual_gateway_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="list_gateway_routes",
        op_kwargs={
            "limit": limit,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "nextToken": next_token,
            "virtualGatewayName": virtual_gateway_name,
        },
    )


async def update(
    hub,
    ctx,
    gateway_route_name: str,
    mesh_name: str,
    spec: Dict,
    virtual_gateway_name: str,
    client_token: str = None,
    mesh_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing gateway route that is associated to a specified virtual gateway in a service mesh.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed. Defaults to None.
        gateway_route_name(str): The name of the gateway route to update.
        mesh_name(str): The name of the service mesh that the gateway route resides in.
        mesh_owner(str, optional): The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see Working with shared meshes. Defaults to None.
        spec(Dict): The new gateway route specification to apply. This overwrites the existing data.
        virtual_gateway_name(str): The name of the virtual gateway that the gateway route is associated with.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appmesh.gateway_route.update(
                ctx,
                gateway_route_name=value,
                mesh_name=value,
                spec=value,
                virtual_gateway_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appmesh.gateway_route.update gateway_route_name=value, mesh_name=value, spec=value, virtual_gateway_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appmesh",
        operation="update_gateway_route",
        op_kwargs={
            "clientToken": client_token,
            "gatewayRouteName": gateway_route_name,
            "meshName": mesh_name,
            "meshOwner": mesh_owner,
            "spec": spec,
            "virtualGatewayName": virtual_gateway_name,
        },
    )
