"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, report_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified report definition in AWS Application Cost Profiler. This stops the report from being generated.

    Args:
        report_id(str): Required. ID of the report to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.applicationcostprofiler.report_definition.delete(
                ctx, report_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.applicationcostprofiler.report_definition.delete report_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="applicationcostprofiler",
        operation="delete_report_definition",
        op_kwargs={"reportId": report_id},
    )


async def get(hub, ctx, report_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the definition of a report already configured in AWS Application Cost Profiler.

    Args:
        report_id(str): ID of the report to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.applicationcostprofiler.report_definition.get(
                ctx, report_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.applicationcostprofiler.report_definition.get report_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="applicationcostprofiler",
        operation="get_report_definition",
        op_kwargs={"reportId": report_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of all reports and their configurations for your AWS account. The maximum number of reports is one.

    Args:
        next_token(str, optional): The token value from a previous call to access the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.applicationcostprofiler.report_definition.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.applicationcostprofiler.report_definition.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="applicationcostprofiler",
        operation="list_report_definitions",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def put(
    hub,
    ctx,
    report_id: str,
    report_description: str,
    report_frequency: str,
    format_: str,
    destination_s3_location: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates the report definition for a report in Application Cost Profiler.

    Args:
        report_id(str): Required. ID of the report. You can choose any valid string matching the pattern for the ID.
        report_description(str): Required. Description of the report.
        report_frequency(str): Required. The cadence to generate the report.
        format_(str): Required. The format to use for the generated report.
        destination_s3_location(Dict): Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.applicationcostprofiler.report_definition.put(
                ctx,
                report_id=value,
                report_description=value,
                report_frequency=value,
                format_=value,
                destination_s3_location=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.applicationcostprofiler.report_definition.put report_id=value, report_description=value, report_frequency=value, format_=value, destination_s3_location=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="applicationcostprofiler",
        operation="put_report_definition",
        op_kwargs={
            "reportId": report_id,
            "reportDescription": report_description,
            "reportFrequency": report_frequency,
            "format": format_,
            "destinationS3Location": destination_s3_location,
        },
    )


async def update(
    hub,
    ctx,
    report_id: str,
    report_description: str,
    report_frequency: str,
    format_: str,
    destination_s3_location: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates existing report in AWS Application Cost Profiler.

    Args:
        report_id(str): Required. ID of the report to update.
        report_description(str): Required. Description of the report.
        report_frequency(str): Required. The cadence to generate the report.
        format_(str): Required. The format to use for the generated report.
        destination_s3_location(Dict): Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.applicationcostprofiler.report_definition.update(
                ctx,
                report_id=value,
                report_description=value,
                report_frequency=value,
                format_=value,
                destination_s3_location=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.applicationcostprofiler.report_definition.update report_id=value, report_description=value, report_frequency=value, format_=value, destination_s3_location=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="applicationcostprofiler",
        operation="update_report_definition",
        op_kwargs={
            "reportId": report_id,
            "reportDescription": report_description,
            "reportFrequency": report_frequency,
            "format": format_,
            "destinationS3Location": destination_s3_location,
        },
    )
