"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"import_": "import"}


async def import_(hub, ctx, source_s3_location: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Ingests application usage data from Amazon Simple Storage Service (Amazon S3). The data must already exist in the S3 location. As part of the action, AWS Application Cost Profiler copies the object from your S3 bucket to an S3 bucket owned by Amazon for processing asynchronously.

    Args:
        source_s3_location(Dict): Amazon S3 location to import application usage data from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.applicationcostprofiler.application_usage.import(ctx, source_s3_location=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.applicationcostprofiler.application_usage.import source_s3_location=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="applicationcostprofiler",
        operation="import_application_usage",
        op_kwargs={"sourceS3Location": source_s3_location},
    )
