"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, problem_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the anomalies or errors associated with the problem.

    Args:
        problem_id(str): The ID of the problem.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.problem.observation.describe_all(
                ctx, problem_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.problem.observation.describe_all problem_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="describe_problem_observations",
        op_kwargs={"ProblemId": problem_id},
    )
