"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, problem_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an application problem.

    Args:
        problem_id(str): The ID of the problem.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.problem.init.describe(ctx, problem_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.problem.init.describe problem_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="describe_problem",
        op_kwargs={"ProblemId": problem_id},
    )


async def list_all(
    hub,
    ctx,
    resource_group_name: str = None,
    start_time: str = None,
    end_time: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the problems with your application.

    Args:
        resource_group_name(str, optional): The name of the resource group. Defaults to None.
        start_time(str, optional): The time when the problem was detected, in epoch seconds. If you don't specify a time frame for the request, problems within the past seven days are returned. Defaults to None.
        end_time(str, optional): The time when the problem ended, in epoch seconds. If not specified, problems within the past seven days are returned. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.
        next_token(str, optional): The token to request the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.problem.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.problem.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="list_problems",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "StartTime": start_time,
            "EndTime": end_time,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
