"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, observation_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an anomaly or error with the application.

    Args:
        observation_id(str): The ID of the observation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.observation.describe(
                ctx, observation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.observation.describe observation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="describe_observation",
        op_kwargs={"ObservationId": observation_id},
    )
