"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "set"


async def list_all(
    hub, ctx, resource_group_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the log pattern sets in the specific application.

    Args:
        resource_group_name(str): The name of the resource group.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.
        next_token(str, optional): The token to request the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.log_pattern.set_.list_all(
                ctx, resource_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.log_pattern.set.list_all resource_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="list_log_pattern_sets",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
