"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    resource_group_name: str,
    pattern_set_name: str,
    pattern_name: str,
    pattern: str,
    rank: int,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an log pattern to a LogPatternSet.

    Args:
        resource_group_name(str): The name of the resource group.
        pattern_set_name(str): The name of the log pattern set.
        pattern_name(str): The name of the log pattern.
        pattern(str): The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.
        rank(int): Rank of the log pattern. Must be a value between 1 and 1,000,000. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank 1 will be the first to get matched to a log line. A pattern of rank 1,000,000 will be last to get matched. When you configure custom log patterns from the console, a Low severity pattern translates to a 750,000 rank. A Medium severity pattern translates to a 500,000 rank. And a High severity pattern translates to a 250,000 rank. Rank values less than 1 or greater than 1,000,000 are reserved for AWS-provided patterns. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.log_pattern.init.create(
                ctx,
                resource_group_name=value,
                pattern_set_name=value,
                pattern_name=value,
                pattern=value,
                rank=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.log_pattern.init.create resource_group_name=value, pattern_set_name=value, pattern_name=value, pattern=value, rank=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="create_log_pattern",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "PatternSetName": pattern_set_name,
            "PatternName": pattern_name,
            "Pattern": pattern,
            "Rank": rank,
        },
    )


async def delete(
    hub, ctx, resource_group_name: str, pattern_set_name: str, pattern_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified log pattern from a LogPatternSet.

    Args:
        resource_group_name(str): The name of the resource group.
        pattern_set_name(str): The name of the log pattern set.
        pattern_name(str): The name of the log pattern.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.log_pattern.init.delete(
                ctx, resource_group_name=value, pattern_set_name=value, pattern_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.log_pattern.init.delete resource_group_name=value, pattern_set_name=value, pattern_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="delete_log_pattern",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "PatternSetName": pattern_set_name,
            "PatternName": pattern_name,
        },
    )


async def describe(
    hub, ctx, resource_group_name: str, pattern_set_name: str, pattern_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Describe a specific log pattern from a LogPatternSet.

    Args:
        resource_group_name(str): The name of the resource group.
        pattern_set_name(str): The name of the log pattern set.
        pattern_name(str): The name of the log pattern.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.log_pattern.init.describe(
                ctx, resource_group_name=value, pattern_set_name=value, pattern_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.log_pattern.init.describe resource_group_name=value, pattern_set_name=value, pattern_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="describe_log_pattern",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "PatternSetName": pattern_set_name,
            "PatternName": pattern_name,
        },
    )


async def list_all(
    hub,
    ctx,
    resource_group_name: str,
    pattern_set_name: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the log patterns in the specific log LogPatternSet.

    Args:
        resource_group_name(str): The name of the resource group.
        pattern_set_name(str, optional): The name of the log pattern set. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.
        next_token(str, optional): The token to request the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.log_pattern.init.list_all(
                ctx, resource_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.log_pattern.init.list_all resource_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="list_log_patterns",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "PatternSetName": pattern_set_name,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    resource_group_name: str,
    pattern_set_name: str,
    pattern_name: str,
    pattern: str = None,
    rank: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a log pattern to a LogPatternSet.

    Args:
        resource_group_name(str): The name of the resource group.
        pattern_set_name(str): The name of the log pattern set.
        pattern_name(str): The name of the log pattern.
        pattern(str, optional): The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported. Defaults to None.
        rank(int, optional): Rank of the log pattern. Must be a value between 1 and 1,000,000. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank 1 will be the first to get matched to a log line. A pattern of rank 1,000,000 will be last to get matched. When you configure custom log patterns from the console, a Low severity pattern translates to a 750,000 rank. A Medium severity pattern translates to a 500,000 rank. And a High severity pattern translates to a 250,000 rank. Rank values less than 1 or greater than 1,000,000 are reserved for AWS-provided patterns. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.log_pattern.init.update(
                ctx, resource_group_name=value, pattern_set_name=value, pattern_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.log_pattern.init.update resource_group_name=value, pattern_set_name=value, pattern_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="update_log_pattern",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "PatternSetName": pattern_set_name,
            "PatternName": pattern_name,
            "Pattern": pattern,
            "Rank": rank,
        },
    )
