"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    resource_group_name: str = None,
    start_time: str = None,
    end_time: str = None,
    event_status: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:    INFO: creating a new alarm or updating an alarm threshold.   WARN: alarm not created due to insufficient data points used to predict thresholds.   ERROR: alarm not created due to permission errors or exceeding quotas.

    Args:
        resource_group_name(str, optional): Resource group to which the application belongs. . Defaults to None.
        start_time(str, optional): The start time of the event. . Defaults to None.
        end_time(str, optional): The end time of the event. Defaults to None.
        event_status(str, optional): The status of the configuration update event. Possible values include INFO, WARN, and ERROR. Defaults to None.
        max_results(int, optional):  The maximum number of results returned by ListConfigurationHistory in paginated output. When this parameter is used, ListConfigurationHistory returns only MaxResults in a single page along with a NextToken response element. The remaining results of the initial request can be seen by sending another ListConfigurationHistory request with the returned NextToken value. If this parameter is not used, then ListConfigurationHistory returns all results. . Defaults to None.
        next_token(str, optional): The NextToken value returned from a previous paginated ListConfigurationHistory request where MaxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the NextToken value. This value is null when there are no more results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.configuration_history.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.configuration_history.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="list_configuration_history",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "StartTime": start_time,
            "EndTime": end_time,
            "EventStatus": event_status,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
