"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, resource_group_name: str, component_name: str, resource_list: List
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a custom component by grouping similar standalone instances to monitor.

    Args:
        resource_group_name(str): The name of the resource group.
        component_name(str): The name of the component.
        resource_list(List): The list of resource ARNs that belong to the component.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.component.init.create(
                ctx, resource_group_name=value, component_name=value, resource_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.component.init.create resource_group_name=value, component_name=value, resource_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="create_component",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "ComponentName": component_name,
            "ResourceList": resource_list,
        },
    )


async def delete(hub, ctx, resource_group_name: str, component_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Ungroups a custom component. When you ungroup custom components, all applicable monitors that are set up for the component are removed and the instances revert to their standalone status.

    Args:
        resource_group_name(str): The name of the resource group.
        component_name(str): The name of the component.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.component.init.delete(
                ctx, resource_group_name=value, component_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.component.init.delete resource_group_name=value, component_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="delete_component",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "ComponentName": component_name,
        },
    )


async def describe(hub, ctx, resource_group_name: str, component_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a component and lists the resources that are grouped together in a component.

    Args:
        resource_group_name(str): The name of the resource group.
        component_name(str): The name of the component.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.component.init.describe(
                ctx, resource_group_name=value, component_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.component.init.describe resource_group_name=value, component_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="describe_component",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "ComponentName": component_name,
        },
    )


async def list_all(
    hub, ctx, resource_group_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the auto-grouped, standalone, and custom components of the application.

    Args:
        resource_group_name(str): The name of the resource group.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.
        next_token(str, optional): The token to request the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.component.init.list_all(
                ctx, resource_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.component.init.list_all resource_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="list_components",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    resource_group_name: str,
    component_name: str,
    new_component_name: str = None,
    resource_list: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the custom component name and/or the list of resources that make up the component.

    Args:
        resource_group_name(str): The name of the resource group.
        component_name(str): The name of the component.
        new_component_name(str, optional): The new name of the component. Defaults to None.
        resource_list(List, optional): The list of resource ARNs that belong to the component. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.component.init.update(
                ctx, resource_group_name=value, component_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.component.init.update resource_group_name=value, component_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="update_component",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "ComponentName": component_name,
            "NewComponentName": new_component_name,
            "ResourceList": resource_list,
        },
    )
