"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub, ctx, resource_group_name: str, component_name: str, tier: str
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the recommended monitoring configuration of the component.

    Args:
        resource_group_name(str): The name of the resource group.
        component_name(str): The name of the component.
        tier(str): The tier of the application component. Supported tiers include DOT_NET_CORE, DOT_NET_WORKER, DOT_NET_WEB, SQL_SERVER, and DEFAULT.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.component.configuration.recommendation.describe(
                ctx, resource_group_name=value, component_name=value, tier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.component.configuration.recommendation.describe resource_group_name=value, component_name=value, tier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="describe_component_configuration_recommendation",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "ComponentName": component_name,
            "Tier": tier,
        },
    )
