"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, resource_group_name: str, component_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the monitoring configuration of the component.

    Args:
        resource_group_name(str): The name of the resource group.
        component_name(str): The name of the component.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.component.configuration.init.describe(
                ctx, resource_group_name=value, component_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.component.configuration.init.describe resource_group_name=value, component_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="describe_component_configuration",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "ComponentName": component_name,
        },
    )


async def update(
    hub,
    ctx,
    resource_group_name: str,
    component_name: str,
    monitor: bool = None,
    tier: str = None,
    component_configuration: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the monitoring configurations for the component. The configuration input parameter is an escaped JSON of the configuration and should match the schema of what is returned by DescribeComponentConfigurationRecommendation.

    Args:
        resource_group_name(str): The name of the resource group.
        component_name(str): The name of the component.
        monitor(bool, optional): Indicates whether the application component is monitored. Defaults to None.
        tier(str, optional): The tier of the application component. Supported tiers include DOT_NET_WORKER, DOT_NET_WEB, DOT_NET_CORE, SQL_SERVER, and DEFAULT. Defaults to None.
        component_configuration(str, optional): The configuration settings of the component. The value is the escaped JSON of the configuration. For more information about the JSON format, see Working with JSON. You can send a request to DescribeComponentConfigurationRecommendation to see the recommended configuration for a component. For the complete format of the component configuration file, see Component Configuration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.component.configuration.init.update(
                ctx, resource_group_name=value, component_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.component.configuration.init.update resource_group_name=value, component_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="update_component_configuration",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "ComponentName": component_name,
            "Monitor": monitor,
            "Tier": tier,
            "ComponentConfiguration": component_configuration,
        },
    )
