"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    resource_group_name: str,
    ops_center_enabled: bool = None,
    cwe_monitor_enabled: bool = None,
    ops_item_sns_topic_arn: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an application that is created from a resource group.

    Args:
        resource_group_name(str): The name of the resource group.
        ops_center_enabled(bool, optional):  When set to true, creates opsItems for any problems detected on an application. . Defaults to None.
        cwe_monitor_enabled(bool, optional):  Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others. . Defaults to None.
        ops_item_sns_topic_arn(str, optional):  The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem. . Defaults to None.
        tags(List, optional): List of tags to add to the application. tag key (Key) and an associated tag value (Value). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.application.create(
                ctx, resource_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.application.create resource_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="create_application",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "OpsCenterEnabled": ops_center_enabled,
            "CWEMonitorEnabled": cwe_monitor_enabled,
            "OpsItemSNSTopicArn": ops_item_sns_topic_arn,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, resource_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified application from monitoring. Does not delete the application.

    Args:
        resource_group_name(str): The name of the resource group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.application.delete(
                ctx, resource_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.application.delete resource_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="delete_application",
        op_kwargs={"ResourceGroupName": resource_group_name},
    )


async def describe(hub, ctx, resource_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the application.

    Args:
        resource_group_name(str): The name of the resource group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.application.describe(
                ctx, resource_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.application.describe resource_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="describe_application",
        op_kwargs={"ResourceGroupName": resource_group_name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the IDs of the applications that you are monitoring.

    Args:
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.
        next_token(str, optional): The token to request the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.application.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.application.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="list_applications",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    resource_group_name: str,
    ops_center_enabled: bool = None,
    cwe_monitor_enabled: bool = None,
    ops_item_sns_topic_arn: str = None,
    remove_sns_topic: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the application.

    Args:
        resource_group_name(str): The name of the resource group.
        ops_center_enabled(bool, optional):  When set to true, creates opsItems for any problems detected on an application. . Defaults to None.
        cwe_monitor_enabled(bool, optional):  Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others. . Defaults to None.
        ops_item_sns_topic_arn(str, optional):  The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem. Defaults to None.
        remove_sns_topic(bool, optional):  Disassociates the SNS topic from the opsItem created for detected problems. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.application_insight.application.update(
                ctx, resource_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.application_insight.application.update resource_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="application-insights",
        operation="update_application",
        op_kwargs={
            "ResourceGroupName": resource_group_name,
            "OpsCenterEnabled": ops_center_enabled,
            "CWEMonitorEnabled": cwe_monitor_enabled,
            "OpsItemSNSTopicArn": ops_item_sns_topic_arn,
            "RemoveSNSTopic": remove_sns_topic,
        },
    )
