"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    event_filter: Dict,
    event_bridge_bus: str,
    description: str = None,
    client_token: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an EventIntegration, given a specified name, description, and a reference to an Amazon EventBridge bus in your account and a partner event source that pushes events to that bus. No objects are created in the your account, only metadata that is persisted on the EventIntegration control plane.

    Args:
        name(str): The name of the event integration.
        description(str, optional): The description of the event integration. Defaults to None.
        event_filter(Dict): The event filter.
        event_bridge_bus(str): The EventBridge bus.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        tags(Dict, optional): One or more tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appintegration.event_integration.init.create(
                ctx, name=value, event_filter=value, event_bridge_bus=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appintegration.event_integration.init.create name=value, event_filter=value, event_bridge_bus=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appintegrations",
        operation="create_event_integration",
        op_kwargs={
            "Name": name,
            "Description": description,
            "EventFilter": event_filter,
            "EventBridgeBus": event_bridge_bus,
            "ClientToken": client_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified existing event integration. If the event integration is associated with clients, the request is rejected.

    Args:
        name(str): The name of the event integration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appintegration.event_integration.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appintegration.event_integration.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appintegrations",
        operation="delete_event_integration",
        op_kwargs={"Name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Return information about the event integration.

    Args:
        name(str): The name of the event integration. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appintegration.event_integration.init.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appintegration.event_integration.init.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appintegrations",
        operation="get_event_integration",
        op_kwargs={"Name": name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a paginated list of event integrations in the account.

    Args:
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appintegration.event_integration.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appintegration.event_integration.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appintegrations",
        operation="list_event_integrations",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(hub, ctx, name: str, description: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the description of an event integration.

    Args:
        name(str): The name of the event integration.
        description(str, optional): The description of the event inegration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appintegration.event_integration.init.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appintegration.event_integration.init.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appintegrations",
        operation="update_event_integration",
        op_kwargs={"Name": name, "Description": description},
    )
