"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    event_integration_name: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a paginated list of event integration associations in the account.

    Args:
        event_integration_name(str): The name of the event integration. .
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appintegration.event_integration.association.list_all(
                ctx, event_integration_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appintegration.event_integration.association.list_all event_integration_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appintegrations",
        operation="list_event_integration_associations",
        op_kwargs={
            "EventIntegrationName": event_integration_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
