"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, flow_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Fetches the execution history of the flow.

    Args:
        flow_name(str):  The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only. .
        max_results(int, optional):  Specifies the maximum number of items that should be returned in the result set. The default for maxResults is 20 (for all paginated API operations). . Defaults to None.
        next_token(str, optional):  The pagination token for the next page of data. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appflow.flow.execution_record.describe_all(ctx, flow_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appflow.flow.execution_record.describe_all flow_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appflow",
        operation="describe_flow_execution_records",
        op_kwargs={
            "flowName": flow_name,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
