"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    connector_profile_name: str,
    connector_type: str,
    connection_mode: str,
    connector_profile_config: Dict,
    kms_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new connector profile associated with your AWS account. There is a soft quota of 100 connector profiles per AWS account. If you need more connector profiles than this quota allows, you can submit a request to the Amazon AppFlow team through the Amazon AppFlow support channel.

    Args:
        connector_profile_name(str):  The name of the connector profile. The name is unique for each ConnectorProfile in your AWS account. .
        kms_arn(str, optional):  The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key. . Defaults to None.
        connector_type(str):  The type of connector, such as Salesforce, Amplitude, and so on. .
        connection_mode(str):  Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. .
        connector_profile_config(Dict):  Defines the connector-specific configuration and credentials. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appflow.connector.profile.create(
                ctx,
                connector_profile_name=value,
                connector_type=value,
                connection_mode=value,
                connector_profile_config=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appflow.connector.profile.create connector_profile_name=value, connector_type=value, connection_mode=value, connector_profile_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appflow",
        operation="create_connector_profile",
        op_kwargs={
            "connectorProfileName": connector_profile_name,
            "kmsArn": kms_arn,
            "connectorType": connector_type,
            "connectionMode": connection_mode,
            "connectorProfileConfig": connector_profile_config,
        },
    )


async def delete(
    hub, ctx, connector_profile_name: str, force_delete: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

     Enables you to delete an existing connector profile.

    Args:
        connector_profile_name(str):  The name of the connector profile. The name is unique for each ConnectorProfile in your account. .
        force_delete(bool, optional):  Indicates whether Amazon AppFlow should delete the profile, even if it is currently in use in one or more flows. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appflow.connector.profile.delete(
                ctx, connector_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appflow.connector.profile.delete connector_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appflow",
        operation="delete_connector_profile",
        op_kwargs={
            "connectorProfileName": connector_profile_name,
            "forceDelete": force_delete,
        },
    )


async def describe_all(
    hub,
    ctx,
    connector_profile_names: List = None,
    connector_type: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of connector-profile details matching the provided connector-profile names and connector-types. Both input lists are optional, and you can use them to filter the result.  If no names or connector-types are provided, returns all connector profiles in a paginated form. If there is no match, this operation returns an empty list.

    Args:
        connector_profile_names(List, optional):  The name of the connector profile. The name is unique for each ConnectorProfile in the AWS account. . Defaults to None.
        connector_type(str, optional):  The type of connector, such as Salesforce, Amplitude, and so on. . Defaults to None.
        max_results(int, optional):  Specifies the maximum number of items that should be returned in the result set. The default for maxResults is 20 (for all paginated API operations). . Defaults to None.
        next_token(str, optional):  The pagination token for the next page of data. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appflow.connector.profile.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appflow.connector.profile.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appflow",
        operation="describe_connector_profiles",
        op_kwargs={
            "connectorProfileNames": connector_profile_names,
            "connectorType": connector_type,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    connector_profile_name: str,
    connection_mode: str,
    connector_profile_config: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates a given connector profile associated with your account.

    Args:
        connector_profile_name(str):  The name of the connector profile and is unique for each ConnectorProfile in the AWS Account. .
        connection_mode(str):  Indicates the connection mode and if it is public or private. .
        connector_profile_config(Dict):  Defines the connector-specific profile configuration and credentials. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appflow.connector.profile.update(
                ctx,
                connector_profile_name=value,
                connection_mode=value,
                connector_profile_config=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appflow.connector.profile.update connector_profile_name=value, connection_mode=value, connector_profile_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appflow",
        operation="update_connector_profile",
        op_kwargs={
            "connectorProfileName": connector_profile_name,
            "connectionMode": connection_mode,
            "connectorProfileConfig": connector_profile_config,
        },
    )
