"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub, ctx, connector_types: List = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Describes the connectors vended by Amazon AppFlow for specified connector types. If you don't specify a connector type, this operation describes all connectors vended by Amazon AppFlow. If there are more connectors than can be returned in one page, the response contains a nextToken object, which can be be passed in to the next call to the DescribeConnectors API operation to retrieve the next page.

    Args:
        connector_types(List, optional):  The type of connector, such as Salesforce, Amplitude, and so on. . Defaults to None.
        next_token(str, optional):  The pagination token for the next page of data. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appflow.connector.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appflow.connector.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appflow",
        operation="describe_connectors",
        op_kwargs={"connectorTypes": connector_types, "nextToken": next_token},
    )
