"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub,
    ctx,
    connector_entity_name: str,
    connector_type: str = None,
    connector_profile_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Provides details regarding the entity used with the connector, with a description of the data model for each entity.

    Args:
        connector_entity_name(str):  The entity name for that connector. .
        connector_type(str, optional):  The type of connector application, such as Salesforce, Amplitude, and so on. . Defaults to None.
        connector_profile_name(str, optional):  The name of the connector profile. The name is unique for each ConnectorProfile in the AWS account. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appflow.connector.entity.describe(
                ctx, connector_entity_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appflow.connector.entity.describe connector_entity_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appflow",
        operation="describe_connector_entity",
        op_kwargs={
            "connectorEntityName": connector_entity_name,
            "connectorType": connector_type,
            "connectorProfileName": connector_profile_name,
        },
    )


async def list_all(
    hub,
    ctx,
    connector_profile_name: str = None,
    connector_type: str = None,
    entities_path: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns the list of available connector entities supported by Amazon AppFlow. For example, you can query Salesforce for Account and Opportunity entities, or query ServiceNow for the Incident entity.

    Args:
        connector_profile_name(str, optional):  The name of the connector profile. The name is unique for each ConnectorProfile in the AWS account, and is used to query the downstream connector. . Defaults to None.
        connector_type(str, optional):  The type of connector, such as Salesforce, Amplitude, and so on. . Defaults to None.
        entities_path(str, optional):  This optional parameter is specific to connector implementation. Some connectors support multiple levels or categories of entities. You can find out the list of roots for such providers by sending a request without the entitiesPath parameter. If the connector supports entities at different roots, this initial request returns the list of roots. Otherwise, this request returns all entities supported by the provider. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appflow.connector.entity.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appflow.connector.entity.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appflow",
        operation="list_connector_entities",
        op_kwargs={
            "connectorProfileName": connector_profile_name,
            "connectorType": connector_type,
            "entitiesPath": entities_path,
        },
    )
