"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    application_id: str,
    configuration_profile_id: str,
    content: bytes,
    content_type: str,
    description: str = None,
    latest_version_number: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new configuration in the AppConfig configuration store.

    Args:
        application_id(str): The application ID.
        configuration_profile_id(str): The configuration profile ID.
        description(str, optional): A description of the configuration. Defaults to None.
        content(bytes): The content of the configuration or the configuration data.
        content_type(str): A standard MIME type describing the format of the configuration content. For more information, see Content-Type.
        latest_version_number(int, optional): An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version of the latest hosted configuration version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.hosted_configuration_version.create(
                ctx,
                application_id=value,
                configuration_profile_id=value,
                content=value,
                content_type=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.hosted_configuration_version.create application_id=value, configuration_profile_id=value, content=value, content_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="create_hosted_configuration_version",
        op_kwargs={
            "ApplicationId": application_id,
            "ConfigurationProfileId": configuration_profile_id,
            "Description": description,
            "Content": content,
            "ContentType": content_type,
            "LatestVersionNumber": latest_version_number,
        },
    )


async def delete(
    hub, ctx, application_id: str, configuration_profile_id: str, version_number: int
) -> None:
    r"""
    **Autogenerated function**

    Delete a version of a configuration from the AppConfig configuration store.

    Args:
        application_id(str): The application ID.
        configuration_profile_id(str): The configuration profile ID.
        version_number(int): The versions number to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.hosted_configuration_version.delete(
                ctx, application_id=value, configuration_profile_id=value, version_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.hosted_configuration_version.delete application_id=value, configuration_profile_id=value, version_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="delete_hosted_configuration_version",
        op_kwargs={
            "ApplicationId": application_id,
            "ConfigurationProfileId": configuration_profile_id,
            "VersionNumber": version_number,
        },
    )


async def get(
    hub, ctx, application_id: str, configuration_profile_id: str, version_number: int
) -> Dict:
    r"""
    **Autogenerated function**

    Get information about a specific configuration version.

    Args:
        application_id(str): The application ID.
        configuration_profile_id(str): The configuration profile ID.
        version_number(int): The version.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.hosted_configuration_version.get(
                ctx, application_id=value, configuration_profile_id=value, version_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.hosted_configuration_version.get application_id=value, configuration_profile_id=value, version_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="get_hosted_configuration_version",
        op_kwargs={
            "ApplicationId": application_id,
            "ConfigurationProfileId": configuration_profile_id,
            "VersionNumber": version_number,
        },
    )


async def list_all(
    hub,
    ctx,
    application_id: str,
    configuration_profile_id: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    View a list of configurations stored in the AppConfig configuration store by version.

    Args:
        application_id(str): The application ID.
        configuration_profile_id(str): The configuration profile ID.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.hosted_configuration_version.list_all(
                ctx, application_id=value, configuration_profile_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.hosted_configuration_version.list_all application_id=value, configuration_profile_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="list_hosted_configuration_versions",
        op_kwargs={
            "ApplicationId": application_id,
            "ConfigurationProfileId": configuration_profile_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
