"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    application_id: str,
    name: str,
    description: str = None,
    monitors: List = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    For each application, you define one or more environments. An environment is a logical deployment group of AppConfig targets, such as applications in a Beta or Production environment. You can also define environments for application subcomponents such as the Web, Mobile and Back-end components for your application. You can configure Amazon CloudWatch alarms for each environment. The system monitors alarms during a configuration deployment. If an alarm is triggered, the system rolls back the configuration.

    Args:
        application_id(str): The application ID.
        name(str): A name for the environment.
        description(str, optional): A description of the environment. Defaults to None.
        monitors(List, optional): Amazon CloudWatch alarms to monitor during the deployment process. Defaults to None.
        tags(Dict, optional): Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.environment.create(
                ctx, application_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.environment.create application_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="create_environment",
        op_kwargs={
            "ApplicationId": application_id,
            "Name": name,
            "Description": description,
            "Monitors": monitors,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, application_id: str, environment_id: str) -> None:
    r"""
    **Autogenerated function**

    Delete an environment. Deleting an environment does not delete a configuration from a host.

    Args:
        application_id(str): The application ID that includes the environment you want to delete.
        environment_id(str): The ID of the environment you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.environment.delete(
                ctx, application_id=value, environment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.environment.delete application_id=value, environment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="delete_environment",
        op_kwargs={"ApplicationId": application_id, "EnvironmentId": environment_id},
    )


async def get(hub, ctx, application_id: str, environment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve information about an environment. An environment is a logical deployment group of AppConfig applications, such as applications in a Production environment or in an EU_Region environment. Each configuration deployment targets an environment. You can enable one or more Amazon CloudWatch alarms for an environment. If an alarm is triggered during a deployment, AppConfig roles back the configuration.

    Args:
        application_id(str): The ID of the application that includes the environment you want to get.
        environment_id(str): The ID of the environment you wnat to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.environment.get(
                ctx, application_id=value, environment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.environment.get application_id=value, environment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="get_environment",
        op_kwargs={"ApplicationId": application_id, "EnvironmentId": environment_id},
    )


async def list_all(
    hub, ctx, application_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List the environments for an application.

    Args:
        application_id(str): The application ID.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.environment.list_all(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.environment.list_all application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="list_environments",
        op_kwargs={
            "ApplicationId": application_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    application_id: str,
    environment_id: str,
    name: str = None,
    description: str = None,
    monitors: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an environment.

    Args:
        application_id(str): The application ID.
        environment_id(str): The environment ID.
        name(str, optional): The name of the environment. Defaults to None.
        description(str, optional): A description of the environment. Defaults to None.
        monitors(List, optional): Amazon CloudWatch alarms to monitor during the deployment process. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.environment.update(
                ctx, application_id=value, environment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.environment.update application_id=value, environment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="update_environment",
        op_kwargs={
            "ApplicationId": application_id,
            "EnvironmentId": environment_id,
            "Name": name,
            "Description": description,
            "Monitors": monitors,
        },
    )
