"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    deployment_duration_in_minutes: int,
    growth_factor: float,
    replicate_to: str,
    description: str = None,
    final_bake_time_in_minutes: int = None,
    growth_type: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    A deployment strategy defines important criteria for rolling out your configuration to the designated targets. A deployment strategy includes: the overall duration required, a percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.

    Args:
        name(str): A name for the deployment strategy.
        description(str, optional): A description of the deployment strategy. Defaults to None.
        deployment_duration_in_minutes(int): Total amount of time for a deployment to last.
        final_bake_time_in_minutes(int, optional): The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back. Defaults to None.
        growth_factor(float): The percentage of targets to receive a deployed configuration during each interval.
        growth_type(str, optional): The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:  Linear: For this type, AppConfig processes the deployment by dividing the total number of targets by the value specified for Step percentage. For example, a linear deployment that uses a Step percentage of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.  Exponential: For this type, AppConfig processes the deployment exponentially using the following formula: G*(2^N). In this formula, G is the growth factor specified by the user and N is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:  2*(2^0)   2*(2^1)   2*(2^2)  Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets. Defaults to None.
        replicate_to(str): Save the deployment strategy to a Systems Manager (SSM) document.
        tags(Dict, optional): Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.deployment.strategy.create(
                ctx,
                name=value,
                deployment_duration_in_minutes=value,
                growth_factor=value,
                replicate_to=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.deployment.strategy.create name=value, deployment_duration_in_minutes=value, growth_factor=value, replicate_to=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="create_deployment_strategy",
        op_kwargs={
            "Name": name,
            "Description": description,
            "DeploymentDurationInMinutes": deployment_duration_in_minutes,
            "FinalBakeTimeInMinutes": final_bake_time_in_minutes,
            "GrowthFactor": growth_factor,
            "GrowthType": growth_type,
            "ReplicateTo": replicate_to,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, deployment_strategy_id: str) -> None:
    r"""
    **Autogenerated function**

    Delete a deployment strategy. Deleting a deployment strategy does not delete a configuration from a host.

    Args:
        deployment_strategy_id(str): The ID of the deployment strategy you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.deployment.strategy.delete(
                ctx, deployment_strategy_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.deployment.strategy.delete deployment_strategy_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="delete_deployment_strategy",
        op_kwargs={"DeploymentStrategyId": deployment_strategy_id},
    )


async def get(hub, ctx, deployment_strategy_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve information about a deployment strategy. A deployment strategy defines important criteria for rolling out your configuration to the designated targets. A deployment strategy includes: the overall duration required, a percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.

    Args:
        deployment_strategy_id(str): The ID of the deployment strategy to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.deployment.strategy.get(
                ctx, deployment_strategy_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.deployment.strategy.get deployment_strategy_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="get_deployment_strategy",
        op_kwargs={"DeploymentStrategyId": deployment_strategy_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List deployment strategies.

    Args:
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.deployment.strategy.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.deployment.strategy.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="list_deployment_strategies",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    deployment_strategy_id: str,
    description: str = None,
    deployment_duration_in_minutes: int = None,
    final_bake_time_in_minutes: int = None,
    growth_factor: float = None,
    growth_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a deployment strategy.

    Args:
        deployment_strategy_id(str): The deployment strategy ID.
        description(str, optional): A description of the deployment strategy. Defaults to None.
        deployment_duration_in_minutes(int, optional): Total amount of time for a deployment to last. Defaults to None.
        final_bake_time_in_minutes(int, optional): The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back. Defaults to None.
        growth_factor(float, optional): The percentage of targets to receive a deployed configuration during each interval. Defaults to None.
        growth_type(str, optional): The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:  Linear: For this type, AppConfig processes the deployment by increments of the growth factor evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the deployed configuration.  Exponential: For this type, AppConfig processes the deployment exponentially using the following formula: G*(2^N). In this formula, G is the growth factor specified by the user and N is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:  2*(2^0)   2*(2^1)   2*(2^2)  Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.deployment.strategy.update(
                ctx, deployment_strategy_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.deployment.strategy.update deployment_strategy_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="update_deployment_strategy",
        op_kwargs={
            "DeploymentStrategyId": deployment_strategy_id,
            "Description": description,
            "DeploymentDurationInMinutes": deployment_duration_in_minutes,
            "FinalBakeTimeInMinutes": final_bake_time_in_minutes,
            "GrowthFactor": growth_factor,
            "GrowthType": growth_type,
        },
    )
