"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, application_id: str, environment_id: str, deployment_number: int
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve information about a configuration deployment.

    Args:
        application_id(str): The ID of the application that includes the deployment you want to get. .
        environment_id(str): The ID of the environment that includes the deployment you want to get. .
        deployment_number(int): The sequence number of the deployment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.deployment.init.get(
                ctx, application_id=value, environment_id=value, deployment_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.deployment.init.get application_id=value, environment_id=value, deployment_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="get_deployment",
        op_kwargs={
            "ApplicationId": application_id,
            "EnvironmentId": environment_id,
            "DeploymentNumber": deployment_number,
        },
    )


async def list_all(
    hub,
    ctx,
    application_id: str,
    environment_id: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the deployments for an environment.

    Args:
        application_id(str): The application ID.
        environment_id(str): The environment ID.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.deployment.init.list_all(
                ctx, application_id=value, environment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.deployment.init.list_all application_id=value, environment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="list_deployments",
        op_kwargs={
            "ApplicationId": application_id,
            "EnvironmentId": environment_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def start(
    hub,
    ctx,
    application_id: str,
    environment_id: str,
    deployment_strategy_id: str,
    configuration_profile_id: str,
    configuration_version: str,
    description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a deployment.

    Args:
        application_id(str): The application ID.
        environment_id(str): The environment ID.
        deployment_strategy_id(str): The deployment strategy ID.
        configuration_profile_id(str): The configuration profile ID.
        configuration_version(str): The configuration version to deploy.
        description(str, optional): A description of the deployment. Defaults to None.
        tags(Dict, optional): Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.deployment.init.start(
                ctx,
                application_id=value,
                environment_id=value,
                deployment_strategy_id=value,
                configuration_profile_id=value,
                configuration_version=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.deployment.init.start application_id=value, environment_id=value, deployment_strategy_id=value, configuration_profile_id=value, configuration_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="start_deployment",
        op_kwargs={
            "ApplicationId": application_id,
            "EnvironmentId": environment_id,
            "DeploymentStrategyId": deployment_strategy_id,
            "ConfigurationProfileId": configuration_profile_id,
            "ConfigurationVersion": configuration_version,
            "Description": description,
            "Tags": tags,
        },
    )


async def stop(
    hub, ctx, application_id: str, environment_id: str, deployment_number: int
) -> Dict:
    r"""
    **Autogenerated function**

    Stops a deployment. This API action works only on deployments that have a status of DEPLOYING. This action moves the deployment to a status of ROLLED_BACK.

    Args:
        application_id(str): The application ID.
        environment_id(str): The environment ID.
        deployment_number(int): The sequence number of the deployment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.deployment.init.stop(
                ctx, application_id=value, environment_id=value, deployment_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.deployment.init.stop application_id=value, environment_id=value, deployment_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="stop_deployment",
        op_kwargs={
            "ApplicationId": application_id,
            "EnvironmentId": environment_id,
            "DeploymentNumber": deployment_number,
        },
    )
