"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    application_id: str,
    name: str,
    location_uri: str,
    description: str = None,
    retrieval_role_arn: str = None,
    validators: List = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Information that enables AppConfig to access the configuration source. Valid configuration sources include Systems Manager (SSM) documents, SSM Parameter Store parameters, and Amazon S3 objects. A configuration profile includes the following information.   The Uri location of the configuration data.   The AWS Identity and Access Management (IAM) role that provides access to the configuration data.   A validator for the configuration data. Available validators include either a JSON Schema or an AWS Lambda function.   For more information, see Create a Configuration and a Configuration Profile in the AWS AppConfig User Guide.

    Args:
        application_id(str): The application ID.
        name(str): A name for the configuration profile.
        description(str, optional): A description of the configuration profile. Defaults to None.
        location_uri(str): A URI to locate the configuration. You can specify a Systems Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For an SSM document, specify either the document name in the format ssm-document://<Document_name> or the Amazon Resource Name (ARN). For a parameter, specify either the parameter name in the format ssm-parameter://<Parameter_name> or the ARN. For an Amazon S3 object, specify the URI in the following format: s3://<bucket>/<objectKey> . Here is an example: s3://my-bucket/my-app/us-east-1/my-config.json.
        retrieval_role_arn(str, optional): The ARN of an IAM role with permission to access the configuration at the specified LocationUri. Defaults to None.
        validators(List, optional): A list of methods for validating the configuration. Defaults to None.
        tags(Dict, optional): Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.configuration.profile.create(
                ctx, application_id=value, name=value, location_uri=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.configuration.profile.create application_id=value, name=value, location_uri=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="create_configuration_profile",
        op_kwargs={
            "ApplicationId": application_id,
            "Name": name,
            "Description": description,
            "LocationUri": location_uri,
            "RetrievalRoleArn": retrieval_role_arn,
            "Validators": validators,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, application_id: str, configuration_profile_id: str) -> None:
    r"""
    **Autogenerated function**

    Delete a configuration profile. Deleting a configuration profile does not delete a configuration from a host.

    Args:
        application_id(str): The application ID that includes the configuration profile you want to delete.
        configuration_profile_id(str): The ID of the configuration profile you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.configuration.profile.delete(
                ctx, application_id=value, configuration_profile_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.configuration.profile.delete application_id=value, configuration_profile_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="delete_configuration_profile",
        op_kwargs={
            "ApplicationId": application_id,
            "ConfigurationProfileId": configuration_profile_id,
        },
    )


async def get(hub, ctx, application_id: str, configuration_profile_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve information about a configuration profile.

    Args:
        application_id(str): The ID of the application that includes the configuration profile you want to get.
        configuration_profile_id(str): The ID of the configuration profile you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.configuration.profile.get(
                ctx, application_id=value, configuration_profile_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.configuration.profile.get application_id=value, configuration_profile_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="get_configuration_profile",
        op_kwargs={
            "ApplicationId": application_id,
            "ConfigurationProfileId": configuration_profile_id,
        },
    )


async def list_all(
    hub, ctx, application_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the configuration profiles for an application.

    Args:
        application_id(str): The application ID.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.configuration.profile.list_all(
                ctx, application_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.configuration.profile.list_all application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="list_configuration_profiles",
        op_kwargs={
            "ApplicationId": application_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    application_id: str,
    configuration_profile_id: str,
    name: str = None,
    description: str = None,
    retrieval_role_arn: str = None,
    validators: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a configuration profile.

    Args:
        application_id(str): The application ID.
        configuration_profile_id(str): The ID of the configuration profile.
        name(str, optional): The name of the configuration profile. Defaults to None.
        description(str, optional): A description of the configuration profile. Defaults to None.
        retrieval_role_arn(str, optional): The ARN of an IAM role with permission to access the configuration at the specified LocationUri. Defaults to None.
        validators(List, optional): A list of methods for validating the configuration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.configuration.profile.update(
                ctx, application_id=value, configuration_profile_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.configuration.profile.update application_id=value, configuration_profile_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="update_configuration_profile",
        op_kwargs={
            "ApplicationId": application_id,
            "ConfigurationProfileId": configuration_profile_id,
            "Name": name,
            "Description": description,
            "RetrievalRoleArn": retrieval_role_arn,
            "Validators": validators,
        },
    )
