"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    application: str,
    environment: str,
    configuration: str,
    client_id: str,
    client_configuration_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Receive information about a configuration.  AWS AppConfig uses the value of the ClientConfigurationVersion parameter to identify the configuration version on your clients. If you don’t send ClientConfigurationVersion with each call to GetConfiguration, your clients receive the current configuration. You are charged each time your clients receive a configuration. To avoid excess charges, we recommend that you include the ClientConfigurationVersion value with every call to GetConfiguration. This value must be saved on your client. Subsequent calls to GetConfiguration must pass this value by using the ClientConfigurationVersion parameter.

    Args:
        application(str): The application to get. Specify either the application name or the application ID.
        environment(str): The environment to get. Specify either the environment name or the environment ID.
        configuration(str): The configuration to get. Specify either the configuration name or the configuration ID.
        client_id(str): A unique ID to identify the client for the configuration. This ID enables AppConfig to deploy the configuration in intervals, as defined in the deployment strategy.
        client_configuration_version(str, optional): The configuration version returned in the most recent GetConfiguration response.  AWS AppConfig uses the value of the ClientConfigurationVersion parameter to identify the configuration version on your clients. If you don’t send ClientConfigurationVersion with each call to GetConfiguration, your clients receive the current configuration. You are charged each time your clients receive a configuration. To avoid excess charges, we recommend that you include the ClientConfigurationVersion value with every call to GetConfiguration. This value must be saved on your client. Subsequent calls to GetConfiguration must pass this value by using the ClientConfigurationVersion parameter.   For more information about working with configurations, see Retrieving the Configuration in the AWS AppConfig User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.configuration.init.get(
                ctx, application=value, environment=value, configuration=value, client_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.configuration.init.get application=value, environment=value, configuration=value, client_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="get_configuration",
        op_kwargs={
            "Application": application,
            "Environment": environment,
            "Configuration": configuration,
            "ClientId": client_id,
            "ClientConfigurationVersion": client_configuration_version,
        },
    )


async def validate(
    hub,
    ctx,
    application_id: str,
    configuration_profile_id: str,
    configuration_version: str,
) -> None:
    r"""
    **Autogenerated function**

    Uses the validators in a configuration profile to validate a configuration.

    Args:
        application_id(str): The application ID.
        configuration_profile_id(str): The configuration profile ID.
        configuration_version(str): The version of the configuration to validate.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.configuration.init.validate(
                ctx,
                application_id=value,
                configuration_profile_id=value,
                configuration_version=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.configuration.init.validate application_id=value, configuration_profile_id=value, configuration_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="validate_configuration",
        op_kwargs={
            "ApplicationId": application_id,
            "ConfigurationProfileId": configuration_profile_id,
            "ConfigurationVersion": configuration_version,
        },
    )
