"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, name: str, description: str = None, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    An application in AppConfig is a logical unit of code that provides capabilities for your customers. For example, an application can be a microservice that runs on Amazon EC2 instances, a mobile application installed by your users, a serverless application using Amazon API Gateway and AWS Lambda, or any system you run on behalf of others.

    Args:
        name(str): A name for the application.
        description(str, optional): A description of the application. Defaults to None.
        tags(Dict, optional): Metadata to assign to the application. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.application.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.application.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="create_application",
        op_kwargs={"Name": name, "Description": description, "Tags": tags},
    )


async def delete(hub, ctx, application_id: str) -> None:
    r"""
    **Autogenerated function**

    Delete an application. Deleting an application does not delete a configuration from a host.

    Args:
        application_id(str): The ID of the application to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.application.delete(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.application.delete application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="delete_application",
        op_kwargs={"ApplicationId": application_id},
    )


async def get(hub, ctx, application_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve information about an application.

    Args:
        application_id(str): The ID of the application you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.application.get(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.application.get application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="get_application",
        op_kwargs={"ApplicationId": application_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List all applications in your AWS account.

    Args:
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.application.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.application.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="list_applications",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub, ctx, application_id: str, name: str = None, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an application.

    Args:
        application_id(str): The application ID.
        name(str, optional): The name of the application. Defaults to None.
        description(str, optional): A description of the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appconfig.application.update(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appconfig.application.update application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appconfig",
        operation="update_application",
        op_kwargs={
            "ApplicationId": application_id,
            "Name": name,
            "Description": description,
        },
    )
