"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    subnet_ids: List,
    security_group_ids: List = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a VPC link.

    Args:
        name(str): The name of the VPC link.
        security_group_ids(List, optional): A list of security group IDs for the VPC link. Defaults to None.
        subnet_ids(List): A list of subnet IDs to include in the VPC link.
        tags(Dict, optional): A list of tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.vpc_link.create(ctx, name=value, subnet_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.vpc_link.create name=value, subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="create_vpc_link",
        op_kwargs={
            "Name": name,
            "SecurityGroupIds": security_group_ids,
            "SubnetIds": subnet_ids,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, vpc_link_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a VPC link.

    Args:
        vpc_link_id(str): The ID of the VPC link.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.vpc_link.delete(ctx, vpc_link_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.vpc_link.delete vpc_link_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_vpc_link",
        op_kwargs={"VpcLinkId": vpc_link_id},
    )


async def get(hub, ctx, vpc_link_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a VPC link.

    Args:
        vpc_link_id(str): The ID of the VPC link.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.vpc_link.get(ctx, vpc_link_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.vpc_link.get vpc_link_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_vpc_link",
        op_kwargs={"VpcLinkId": vpc_link_id},
    )


async def get_all(hub, ctx, max_results: str = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a collection of VPC links.

    Args:
        max_results(str, optional): The maximum number of elements to be returned for this resource. Defaults to None.
        next_token(str, optional): The next page of elements from this collection. Not valid for the last element of the collection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.vpc_link.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.vpc_link.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_vpc_links",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(hub, ctx, vpc_link_id: str, name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates a VPC link.

    Args:
        name(str, optional): The name of the VPC link. Defaults to None.
        vpc_link_id(str): The ID of the VPC link.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.vpc_link.update(ctx, vpc_link_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.vpc_link.update vpc_link_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="update_vpc_link",
        op_kwargs={"Name": name, "VpcLinkId": vpc_link_id},
    )
