"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    api_id: str,
    stage_name: str,
    access_log_settings: Dict = None,
    auto_deploy: bool = None,
    client_certificate_id: str = None,
    default_route_settings: Dict = None,
    deployment_id: str = None,
    description: str = None,
    route_settings: Dict = None,
    stage_variables: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Stage for an API.

    Args:
        access_log_settings(Dict, optional): Settings for logging access in this stage. Defaults to None.
        api_id(str): The API identifier.
        auto_deploy(bool, optional): Specifies whether updates to an API automatically trigger a new deployment. The default value is false. Defaults to None.
        client_certificate_id(str, optional): The identifier of a client certificate for a Stage. Supported only for WebSocket APIs. Defaults to None.
        default_route_settings(Dict, optional): The default route settings for the stage. Defaults to None.
        deployment_id(str, optional): The deployment identifier of the API stage. Defaults to None.
        description(str, optional): The description for the API stage. Defaults to None.
        route_settings(Dict, optional): Route settings for the stage, by routeKey. Defaults to None.
        stage_name(str): The name of the stage.
        stage_variables(Dict, optional): A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&=,]+. Defaults to None.
        tags(Dict, optional): The collection of tags. Each tag element is associated with a given resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.stage.create(ctx, api_id=value, stage_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.stage.create api_id=value, stage_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="create_stage",
        op_kwargs={
            "AccessLogSettings": access_log_settings,
            "ApiId": api_id,
            "AutoDeploy": auto_deploy,
            "ClientCertificateId": client_certificate_id,
            "DefaultRouteSettings": default_route_settings,
            "DeploymentId": deployment_id,
            "Description": description,
            "RouteSettings": route_settings,
            "StageName": stage_name,
            "StageVariables": stage_variables,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, api_id: str, stage_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a Stage.

    Args:
        api_id(str): The API identifier.
        stage_name(str): The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.stage.delete(ctx, api_id=value, stage_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.stage.delete api_id=value, stage_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_stage",
        op_kwargs={"ApiId": api_id, "StageName": stage_name},
    )


async def get(hub, ctx, api_id: str, stage_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a Stage.

    Args:
        api_id(str): The API identifier.
        stage_name(str): The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.stage.get(ctx, api_id=value, stage_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.stage.get api_id=value, stage_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_stage",
        op_kwargs={"ApiId": api_id, "StageName": stage_name},
    )


async def get_all(
    hub, ctx, api_id: str, max_results: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the Stages for an API.

    Args:
        api_id(str): The API identifier.
        max_results(str, optional): The maximum number of elements to be returned for this resource. Defaults to None.
        next_token(str, optional): The next page of elements from this collection. Not valid for the last element of the collection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.stage.get_all(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.stage.get_all api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_stages",
        op_kwargs={"ApiId": api_id, "MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    api_id: str,
    stage_name: str,
    access_log_settings: Dict = None,
    auto_deploy: bool = None,
    client_certificate_id: str = None,
    default_route_settings: Dict = None,
    deployment_id: str = None,
    description: str = None,
    route_settings: Dict = None,
    stage_variables: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a Stage.

    Args:
        access_log_settings(Dict, optional): Settings for logging access in this stage. Defaults to None.
        api_id(str): The API identifier.
        auto_deploy(bool, optional): Specifies whether updates to an API automatically trigger a new deployment. The default value is false. Defaults to None.
        client_certificate_id(str, optional): The identifier of a client certificate for a Stage. Defaults to None.
        default_route_settings(Dict, optional): The default route settings for the stage. Defaults to None.
        deployment_id(str, optional): The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled. Defaults to None.
        description(str, optional): The description for the API stage. Defaults to None.
        route_settings(Dict, optional): Route settings for the stage. Defaults to None.
        stage_name(str): The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.
        stage_variables(Dict, optional): A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&=,]+. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.stage.update(ctx, api_id=value, stage_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.stage.update api_id=value, stage_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="update_stage",
        op_kwargs={
            "AccessLogSettings": access_log_settings,
            "ApiId": api_id,
            "AutoDeploy": auto_deploy,
            "ClientCertificateId": client_certificate_id,
            "DefaultRouteSettings": default_route_settings,
            "DeploymentId": deployment_id,
            "Description": description,
            "RouteSettings": route_settings,
            "StageName": stage_name,
            "StageVariables": stage_variables,
        },
    )
