"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def delete_multiple(
    hub, ctx, api_id: str, route_key: str, stage_name: str
) -> None:
    r"""
    **Autogenerated function**

    Deletes the RouteSettings for a stage.

    Args:
        api_id(str): The API identifier.
        route_key(str): The route key.
        stage_name(str): The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.route.setting.delete_multiple(
                ctx, api_id=value, route_key=value, stage_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.route.setting.delete_multiple api_id=value, route_key=value, stage_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_route_settings",
        op_kwargs={"ApiId": api_id, "RouteKey": route_key, "StageName": stage_name},
    )
