"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    api_id: str,
    route_id: str,
    route_response_key: str,
    model_selection_expression: str = None,
    response_models: Dict = None,
    response_parameters: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a RouteResponse for a Route.

    Args:
        api_id(str): The API identifier.
        model_selection_expression(str, optional): The model selection expression for the route response. Supported only for WebSocket APIs. Defaults to None.
        response_models(Dict, optional): The response models for the route response. Defaults to None.
        response_parameters(Dict, optional): The route response parameters. Defaults to None.
        route_id(str): The route ID.
        route_response_key(str): The route response key.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.route.response.create(
                ctx, api_id=value, route_id=value, route_response_key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.route.response.create api_id=value, route_id=value, route_response_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="create_route_response",
        op_kwargs={
            "ApiId": api_id,
            "ModelSelectionExpression": model_selection_expression,
            "ResponseModels": response_models,
            "ResponseParameters": response_parameters,
            "RouteId": route_id,
            "RouteResponseKey": route_response_key,
        },
    )


async def delete(hub, ctx, api_id: str, route_id: str, route_response_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a RouteResponse.

    Args:
        api_id(str): The API identifier.
        route_id(str): The route ID.
        route_response_id(str): The route response ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.route.response.delete(
                ctx, api_id=value, route_id=value, route_response_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.route.response.delete api_id=value, route_id=value, route_response_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_route_response",
        op_kwargs={
            "ApiId": api_id,
            "RouteId": route_id,
            "RouteResponseId": route_response_id,
        },
    )


async def get(hub, ctx, api_id: str, route_id: str, route_response_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a RouteResponse.

    Args:
        api_id(str): The API identifier.
        route_id(str): The route ID.
        route_response_id(str): The route response ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.route.response.get(
                ctx, api_id=value, route_id=value, route_response_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.route.response.get api_id=value, route_id=value, route_response_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_route_response",
        op_kwargs={
            "ApiId": api_id,
            "RouteId": route_id,
            "RouteResponseId": route_response_id,
        },
    )


async def get_all(
    hub,
    ctx,
    api_id: str,
    route_id: str,
    max_results: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the RouteResponses for a Route.

    Args:
        api_id(str): The API identifier.
        max_results(str, optional): The maximum number of elements to be returned for this resource. Defaults to None.
        next_token(str, optional): The next page of elements from this collection. Not valid for the last element of the collection. Defaults to None.
        route_id(str): The route ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.route.response.get_all(
                ctx, api_id=value, route_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.route.response.get_all api_id=value, route_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_route_responses",
        op_kwargs={
            "ApiId": api_id,
            "MaxResults": max_results,
            "NextToken": next_token,
            "RouteId": route_id,
        },
    )


async def update(
    hub,
    ctx,
    api_id: str,
    route_id: str,
    route_response_id: str,
    model_selection_expression: str = None,
    response_models: Dict = None,
    response_parameters: Dict = None,
    route_response_key: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a RouteResponse.

    Args:
        api_id(str): The API identifier.
        model_selection_expression(str, optional): The model selection expression for the route response. Supported only for WebSocket APIs. Defaults to None.
        response_models(Dict, optional): The response models for the route response. Defaults to None.
        response_parameters(Dict, optional): The route response parameters. Defaults to None.
        route_id(str): The route ID.
        route_response_id(str): The route response ID.
        route_response_key(str, optional): The route response key. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.route.response.update(
                ctx, api_id=value, route_id=value, route_response_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.route.response.update api_id=value, route_id=value, route_response_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="update_route_response",
        op_kwargs={
            "ApiId": api_id,
            "ModelSelectionExpression": model_selection_expression,
            "ResponseModels": response_models,
            "ResponseParameters": response_parameters,
            "RouteId": route_id,
            "RouteResponseId": route_response_id,
            "RouteResponseKey": route_response_key,
        },
    )
